/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.newsalary;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.newsalary.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "BBH1";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u8d44\u6279\u91cf\u4ee3\u53d1\u4e1a\u52a1", (String)"PayImpl_40", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return this.isSalary(info) && BankBusinessConfig.isUseBBH1ForSalary();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        int len = paymentInfos.length;
        Element body = new Element("body");
        String transMasterID = BankBusinessConfig.getPayTransNo(paymentInfo.getAccNo());
        if (StringUtils.isEmpty((String)transMasterID)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684\u2018\u4ea4\u6613\u5ba2\u6237\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_100", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transMasterID);
        String unitNo = "";
        if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            unitNo = BankBusinessConfig.getUnitNo(paymentInfo.getAccNo());
            if (StringUtils.isEmpty((String)unitNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"QueryPayImpl_21", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)body, (String)"unitNo", (String)unitNo.trim());
            JDomUtils.addChild((Element)body, (String)"costItemCode", (String)"1002");
        } else {
            unitNo = BankBusinessConfig.getUnitNoOther(paymentInfo.getAccNo());
            if (StringUtils.isEmpty((String)unitNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"QueryPayImpl_22", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)body, (String)"unitNo", (String)unitNo.trim());
            JDomUtils.addChild((Element)body, (String)"costItemCode", (String)"1001");
        }
        if (StringUtils.isEmpty((String)unitNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u5728\u94f6\u4f01\u5e73\u53f0\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u6216\u524d\u7f6e\u673a\u914d\u7f6e\u8fdb\u884c\u914d\u7f6e\u3002", (String)"PayImpl_101", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        if (BankBusinessConfig.isPayByAuthority().booleanValue()) {
            JDomUtils.addChild((Element)body, (String)"authMasterID", (String)CommonUtils.getClientID(paymentInfo.getAccNo()));
        } else {
            JDomUtils.addChild((Element)body, (String)"authMasterID", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"onlyChannelFlag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"thirdChannelID", (String)"");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)String.valueOf(len));
        Element totalAmountElement = JDomUtils.addChild((Element)body, (String)"totalAmount");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)Sequence.getAutoincrementNumber((int)6));
        JDomUtils.addChild((Element)body, (String)"note0", (String)"");
        JDomUtils.addChild((Element)body, (String)"note", (String)"");
        JDomUtils.addChild((Element)body, (String)"note1", (String)"");
        JDomUtils.addChild((Element)body, (String)"note2", (String)"");
        JDomUtils.addChild((Element)body, (String)"note3", (String)"");
        JDomUtils.addChild((Element)body, (String)"isNewFile", (String)"0");
        Element listsEle = JDomUtils.addChild((Element)body, (String)"lists");
        listsEle.setAttribute("name", "LoopResult");
        Element listElement = null;
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < len; ++i) {
            listElement = JDomUtils.addChild((Element)listsEle, (String)"list");
            String abstractMsg = paymentInfos[i].getExplanation();
            if (StringUtils.isNotEmpty((String)abstractMsg) && abstractMsg.length() > 11) {
                abstractMsg = abstractMsg.substring(0, 11);
            }
            String content = paymentInfos[i].getIncomeAccNo() + "|" + paymentInfos[i].getAmount().setScale(2, 4).toString() + "|" + paymentInfos[i].getIncomeAccName() + "|" + paymentInfos[i].getBankDetailSeqId() + "|" + abstractMsg + "||||";
            JDomUtils.addChild((Element)listElement, (String)"detailedContent", (String)content);
            totalAmt = totalAmt.add(paymentInfos[i].getAmount());
        }
        totalAmountElement.setText(totalAmt.setScale(2, 4).toString());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("BBH1", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String entrustSeqNo = body.getChildTextTrim("handleSeqNo");
            if (StringUtils.isEmpty((String)entrustSeqNo)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u672a\u8fd4\u56de'\u53d7\u7406\u7f16\u53f7'\uff0c\u9700\u8981\u540e\u7eed\u540c\u6b65\u72b6\u6001\u3002", (String)"PayImpl_50", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                Packer.setEntrustSeqNo(paymentInfos, entrustSeqNo);
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

