/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.salary;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.salary.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "5652";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"10.1 5652\u4ee3\u53d1\u5de5\u8d44\u6587\u4ef6\u63d0\u4ea4/\u9884\u6821\u9a8c;10.2 5626 \u4ee3\u53d1\u5de5\u8d44\u4fe1\u606f\u67e5\u8be2;10.3 5630\u4ee3\u53d1\u5de5\u8d44\u6587\u4ef6\u63d0\u4ea4/\u9884\u6821\u9a8c\u7ed3\u679c\u4fe1\u606f\u67e5\u8be2", (String)"PayImpl_24", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return this.isSalary(info) && !BankBusinessConfig.isUse8802ForSalary() && !BankBusinessConfig.isUseBBH1ForSalary();
    }

    public String pack(BankPayRequest request) {
        String unitNo;
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        int len = paymentInfos.length;
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)paymentInfo.getBankBatchSeqId());
        if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            unitNo = BankBusinessConfig.getUnitNo(paymentInfo.getAccNo());
            if (StringUtils.isEmpty((String)unitNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_25", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)body, (String)"unitNo", (String)unitNo.trim());
            JDomUtils.addChild((Element)body, (String)"businessType", (String)"1002");
        } else {
            unitNo = BankBusinessConfig.getUnitNoOther(paymentInfo.getAccNo());
            if (StringUtils.isEmpty((String)unitNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_26", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)body, (String)"unitNo", (String)unitNo.trim());
            JDomUtils.addChild((Element)body, (String)"businessType", (String)"1001");
        }
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"bespeakDate", (String)"");
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)String.valueOf(len));
        Element totalAmountElement = JDomUtils.addChild((Element)body, (String)"totalAmount");
        JDomUtils.addChild((Element)body, (String)"flag", (String)"2");
        Element listsEle = JDomUtils.addChild((Element)body, (String)"lists");
        listsEle.setAttribute("name", "SalaryList");
        if (BankBusinessConfig.isPayByAuthority().booleanValue()) {
            JDomUtils.addChild((Element)body, (String)"authMasterID", (String)CommonUtils.getClientID(request.getAcnt().getAccNo()));
        } else {
            JDomUtils.addChild((Element)body, (String)"authMasterID", (String)"");
        }
        Element listElement = null;
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < len; ++i) {
            listElement = JDomUtils.addChild((Element)listsEle, (String)"list");
            JDomUtils.addChild((Element)listElement, (String)"payeeAcctNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)listElement, (String)"payeeName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)listElement, (String)"amount", (String)paymentInfos[i].getAmount().setScale(2, 4).toString());
            JDomUtils.addChild((Element)listElement, (String)"note", (String)CommonUtils.getExplanationForSalary(paymentInfos[i]));
            totalAmt = totalAmt.add(paymentInfos[i].getAmount());
        }
        totalAmountElement.setText(totalAmt.setScale(2, 4).toString());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("5652", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String entrustSeqNo = body.getChildTextTrim("entrustSeqNo");
            if (StringUtils.isEmpty((String)entrustSeqNo)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u672a\u8fd4\u56de'\u4e1a\u52a1\u59d4\u6258\u7f16\u53f7'\uff0c\u9700\u8981\u540e\u7eed\u540c\u6b65\u72b6\u6001\u3002", (String)"PayImpl_27", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                Packer.setEntrustSeqNo(paymentInfos, entrustSeqNo);
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

