/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbcmys.dc;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    public static final PropertyConfigItem HSBCMYS_DC_BICCODE = PropertyConfigItem.builder().key("HSBCMYS_DC_BICCODE").mlName(new MultiLangEnumBridge("SWIFT CODE", "", "ebg-aqap-banks-hsbcmys-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("SWFIT Code\uff08\u94f6\u884c\u56fd\u9645\u4ee3\u7801\uff09\uff1a\u8de8\u5883\u652f\u4ed8/\u5883\u5185\u5916\u5e01\u4e1a\u52a1\u4f7f\u7528\uff0c\u901a\u5e38\u75318\u621611\u4f4d\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u6210\u3002", "BankBusinessConfig_0", "ebg-aqap-banks-hsbcmys-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u4ed8\u6b3e\u63a5\u53e3\u6709\uff1aACH\u3001CHECK\u3001PP\u63a5\u53e3\u3002", "BankBusinessConfig_1", "ebg-aqap-banks-hsbcmys-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBCMYS_DC_BANKNAME = PropertyConfigItem.builder().key("HSBCMYS_DC_BANKNAME").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-hsbcmys-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-hsbcmys-dc")})).isAccNo(true).defaultValues((List)Lists.newArrayList((Object[])new String[]{""})).build();
    public static final PropertyConfigItem HSBCMYS_DC_PAY_COMPANY_ACNT = PropertyConfigItem.builder().key("HSBCMYS_DC_PAY_COMPANY_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-hsbcmys-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-hsbcmys-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBCMYS_DC_PAY_COMPANY_STREET_ACNT = PropertyConfigItem.builder().key("HSBCMYS_DC_PAY_COMPANY_STREET_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_4", "ebg-aqap-banks-hsbcmys-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_4", "ebg-aqap-banks-hsbcmys-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBCMYS_DC_PAY_COMPANY_CTRY_ACNT = PropertyConfigItem.builder().key("HSBCMYS_DC_PAY_COMPANY_CTRY_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u56fd\u5bb6\u6216\u5730\u533a\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_5", "ebg-aqap-banks-hsbcmys-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u56fd\u5bb6\u6216\u5730\u533a\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_5", "ebg-aqap-banks-hsbcmys-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem DBRT_ID = PropertyConfigItem.builder().key("DBRT_ID").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u5408\u540c\u7f16\u53f7", "BankBusinessConfig_8", "ebg-aqap-banks-hsbcmys-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("ACH\u4ed8\u6b3e\u5408\u540c\u7f16\u53f7\uff0c\u5982\u6709\u591a\u4e2a\uff0c\u53ef\u4ee5\u7528\u9017\u53f7\u5206\u9694\u3002", "BankBusinessConfig_9", "ebg-aqap-banks-hsbcmys-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem HSBCMYS_DC_PAY_PROTOCOL = PropertyConfigItem.builder().key("HSBCMYS_DC_PAY_PROTOCOL").mlName(new MultiLangEnumBridge("\u7528\u6237\u4e0e\u94f6\u884c\u7b7e\u8ba2\u7684\u534f\u8bae", "BankBusinessConfig_10", "ebg-aqap-banks-hsbcmys-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u7528\u6237\u4f7f\u7528\u7684\u534f\u8bae\uff0c\u5982AUTH", "BankBusinessConfig_11", "ebg-aqap-banks-hsbcmys-dc")})).build();
    private static final PropertyConfigItem HSBCMYS_DC_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("HSBCMYS_DC_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4", "BankBusinessConfig_15", "ebg-aqap-banks-hsbcmys-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_16", "ebg-aqap-banks-hsbcmys-dc")})).build();
    private static final PropertyConfigItem HSBCMYS_DC_DETAIL_SELECT = PropertyConfigItem.builder().key("HSBCMYS_DC_DETAIL_SELECT").mlName(new MultiLangEnumBridge("\u5bf9\u8d26\u5355\u4e0b\u8f7d\u65b9\u5f0f", "BankBusinessConfig_17", "ebg-aqap-banks-hsbcmys-dc")).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u53ea\u4e0bCAMT53", "BankBusinessConfig_19", "ebg-aqap-banks-hsbcmys-dc"), new MultiLangEnumBridge("CAMT53&CAMT52", "", "ebg-aqap-banks-hsbcmys-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"CAMT53", "CAMT53&CAMT52"})).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("CAMT53\u662f\u5168\u91cf\u63a8\u9001\u524d\u4e00\u5929\u7684\u4ea4\u6613\u660e\u7ec6\uff0cCAMT52\u662f\u63a8\u9001\u7684\u5f53\u5929\u660e\u7ec6\uff0c\u94f6\u884c\u76ee\u524dCAMT53\u548cCAMT52\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u53ef\u80fd\u5b58\u5728\u4e0d\u4e00\u81f4\u6027\uff0c\u9009\u62e9\u201cCAMT53&CAMT52\u201d\u53ef\u80fd\u4f1a\u5bfc\u81f4\u4ea4\u6613\u660e\u7ec6\u91cd\u590d\uff0c\u8bf7\u614e\u91cd\u9009\u62e9\u3002", "BankBusinessConfig_18", "ebg-aqap-banks-hsbcmys-dc")})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"CAMT53"})).mustInput(true).type(BankPropertyConfigType.BAL_DETAIL_PARAM.getName()).build();

    public static List<String> getDBRTID(String accNo) {
        return DBRT_ID.getCurrentValuesWithObjectID(accNo);
    }

    public static String getPayProtocol() {
        return HSBCMYS_DC_PAY_PROTOCOL.getCurrentValue();
    }

    public static String getBicCode(String accNo) {
        return HSBCMYS_DC_BICCODE.getCurrentValueWithObjectID(accNo);
    }

    public static String getBankName(String accNo) {
        return HSBCMYS_DC_BANKNAME.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCompanyName(String accNo) {
        return HSBCMYS_DC_PAY_COMPANY_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayStreetName(String accNo) {
        return HSBCMYS_DC_PAY_COMPANY_STREET_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCountryName(String accNo) {
        return HSBCMYS_DC_PAY_COMPANY_CTRY_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getCompany(String accNo) {
        return BankBusinessConfig.getPayCompanyName(accNo);
    }

    public static String getStreet(String accNo) {
        return BankBusinessConfig.getPayStreetName(accNo);
    }

    public static String getCountry(String accNo) {
        return BankBusinessConfig.getPayCountryName(accNo);
    }

    public static int getPayStateTimeout() {
        String timeOut = HSBCMYS_DC_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != timeOut && timeOut.length() > 0) {
            try {
                if (Integer.parseInt(timeOut) > 0) {
                    timeout = Integer.parseInt(timeOut);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime deadlineTime = submitSuccessTime.plus(payStateTimeout, ChronoUnit.HOURS);
        return deadlineTime.isBefore(LocalDateTime.now());
    }

    public static boolean isOnlyUseCAMT53() {
        return "CAMT53".equals(HSBCMYS_DC_DETAIL_SELECT.getCurrentValue());
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        ArrayList propertyConfigItems = Lists.newArrayList((Object[])new PropertyConfigItem[]{DBRT_ID, HSBCMYS_DC_BICCODE, HSBCMYS_DC_BANKNAME, HSBCMYS_DC_PAY_COMPANY_ACNT, HSBCMYS_DC_PAY_PROTOCOL, HSBCMYS_DC_PAY_COMPANY_STREET_ACNT, HSBCMYS_DC_PAY_COMPANY_CTRY_ACNT, HSBCMYS_DC_PAY_STATE_TIMEOUT, HSBCMYS_DC_DETAIL_SELECT});
        List bankProps = this.getBankAddtionalPropertyConfigItems(false, false, false);
        bankProps.addAll(propertyConfigItems);
        return bankProps;
    }

    public boolean isForeignBank() {
        return true;
    }
}

