/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbb.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbb.dc.util.DateUtils;
import kd.ebg.aqap.banks.hbb.dc.util.HeadPacker;
import kd.ebg.aqap.banks.hbb.dc.util.HeadParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private final String TRANCODE = "eb2e-acmgmt.AcctDetailQry";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/eb2e-acmgmt.AcctDetailQry.do?";
        try {
            s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userPassword") + "&SIGDATA=1";
        }
        catch (EBServiceException e) {
            logger.info(e.toString());
        }
        catch (IllegalArgumentException e) {
            logger.info(e.toString());
        }
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return super.hisDetail(request);
    }

    public String pack(BankDetailRequest request) {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)HeadPacker.buildHead("eb2e-acmgmt.AcctDetailQry", Sequence.gen18Sequence()));
        String curPage = "0".equals(this.getCurrentPage()) ? "1" : this.getCurrentPage();
        this.setCurrentPage(curPage);
        JDomUtils.addChild((Element)ebank_root, (Element)this.getDetailRequestBody(request, curPage, "100"));
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }

    private Element getDetailRequestBody(BankDetailRequest request, String pageTag, String page) throws EBServiceException {
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"acNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)DateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)DateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"pageIndex", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"pageSize", (String)page);
        return body;
    }

    public EBBankDetailResponse parse(BankDetailRequest arg0, String arg1) {
        this.processPageTag(arg1);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = arg0.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)arg1, (String)encoding);
        Element head = ebenk.getChild("Head");
        BankResponse bankResponse = HeadParser.parserCommonInfo(ebenk);
        Element body = ebenk.getChild("Body");
        if ("00000000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            String count = body.getChildText("recordNumber");
            Integer TotleCount = Integer.parseInt(count);
            if (TotleCount == 0) {
                return new EBBankDetailResponse();
            }
            List list = body.getChildren("list");
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
            for (Element row : list) {
                DetailInfo detail = new DetailInfo();
                try {
                    String payeeAcNo = row.getChildTextTrim("oppAcNo");
                    String payeeAcName = row.getChildTextTrim("oppAcName");
                    String otherBankName = row.getChildTextTrim("otherBankName");
                    String currency = row.getChildTextTrim("currency");
                    detail.setCurrency(StringUtils.isEmpty((String)currency) ? arg0.getBankCurrency() : currency);
                    detail.setOppAccNo(payeeAcNo);
                    detail.setOppAccName(payeeAcName);
                    detail.setAccName(acnt.getAccName());
                    detail.setAccNo(acnt.getAccNo());
                    detail.setOppBankName(otherBankName);
                    String transferDate = row.getChildTextTrim("transDate");
                    String transferTime = row.getChildTextTrim("transTime");
                    String jnlNo = row.getChildTextTrim("jnlNo");
                    if (StringUtils.isEmpty((String)transferTime)) {
                        transferTime = "000000";
                    } else if (transferTime.length() == 5) {
                        transferTime = "0" + transferTime;
                    } else if (transferTime.length() == 4) {
                        transferTime = "00" + transferTime;
                    } else if (transferTime.length() == 3) {
                        transferTime = "000" + transferTime;
                    } else if (transferTime.length() == 2) {
                        transferTime = "0000" + transferTime;
                    } else if (transferTime.length() == 1) {
                        transferTime = "00000" + transferTime;
                    } else if (transferTime.length() > 6) {
                        transferTime = transferTime.substring(0, 6);
                    }
                    Date transTime = DateUtils.parseGLBTransTime(transferDate + " " + transferTime);
                    detail.setTransTime(LocalDateTime.ofInstant(transTime.toInstant(), ZoneId.systemDefault()));
                    detail.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                    String payAmount = row.getChildTextTrim("amount");
                    String recAmount = row.getChildTextTrim("amount");
                    BigDecimal payAmountD = new BigDecimal(payAmount);
                    BigDecimal recAmountD = new BigDecimal(recAmount);
                    String CDFlag = row.getChildTextTrim("dcFlag");
                    if (CDFlag.equalsIgnoreCase("D")) {
                        detail.setDebitAmount(payAmountD);
                        detail.setCreditAmount(new BigDecimal(0));
                    } else {
                        if (!CDFlag.equalsIgnoreCase("C")) continue;
                        detail.setDebitAmount(new BigDecimal(0));
                        detail.setCreditAmount(recAmountD);
                    }
                    String AcctBal = row.getChildTextTrim("balance");
                    if (StringUtils.isNotEmpty((String)AcctBal)) {
                        BigDecimal balance = new BigDecimal(AcctBal);
                        detail.setBalance(balance);
                    }
                    String summary = "";
                    if (row.getChildTextTrim("remark") != null) {
                        summary = row.getChildTextTrim("remark");
                    }
                    if (summary.contains("KD@")) {
                        String[] summaries = summary.split("KD@");
                        if (summaries.length == 2) {
                            summary = summaries[0];
                        }
                        DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)summaries[summaries.length - 1]);
                    }
                    detail.setExplanation(summary);
                    StringBuilder sBuffer = new StringBuilder();
                    sBuffer.append(acnt.getAccNo()).append("_").append(transferDate).append("_").append(jnlNo).append("_").append(payAmount);
                    String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                    String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), transferDate, jsonStr);
                    if (countMap.containsKey(receiptNo)) {
                        int countInt = (Integer)countMap.get(receiptNo) + 1;
                        countMap.put(receiptNo, countInt);
                        receiptNo = receiptNo + "-" + String.format("%04d", countInt);
                    } else {
                        countMap.put(receiptNo, 0);
                    }
                    detail.setReceiptNo(receiptNo);
                    detail.setBankDetailNo(jnlNo);
                    detail.setJsonMap(jsonStr);
                    detailList.add(detail);
                }
                catch (Exception e) {
                    logger.error("\u660e\u7ec6\u6570\u636e\u6709\u8bef", (Throwable)e);
                }
            }
        } else {
            if ("BDP0538".equalsIgnoreCase(bankResponse.getResponseCode())) {
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseCode()));
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getBizCode() {
        return "eb2e-acmgmt.AcctDetailQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u660e\u7ec6\u67e5\u8be2\uff08eb2e-acmgmt.AcctDetailQry\uff09", (String)"DetailImpl_1", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]);
    }

    public String getDeveloper() {
        return "simon_wx";
    }

    private void processPageTag(String responseStr) {
        int pageNo = Integer.parseInt(this.getCurrentPage());
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse bankResponse = HeadParser.parserCommonInfo(root);
        if ("BDP0538".equalsIgnoreCase(bankResponse.getResponseCode())) {
            this.setLastPage(true);
        }
        Element Body = root.getChild("Body");
        int recAmount = Integer.parseInt(Body.getChildTextTrim("recordNumber"));
        List rowList = Body.getChildren("list");
        if (rowList == null || rowList.size() < 100) {
            this.setLastPage(true);
        } else if ((pageNo - 1) * 100 + rowList.size() >= recAmount) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(pageNo + 1);
        }
    }

    public boolean isSupportPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }
}

