/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.utils;

import com.alibaba.fastjson.JSON;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.config.EntAppConfig;
import com.czb.sap.sdk.exception.SdkException;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import java.util.Base64;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.opa.ZsbOpaMetaDataImpl;
import kd.ebg.aqap.banks.zsb.opa.services.token.TokenService;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SdkInit {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SdkInit.class);

    public static String sdkError(SdkException e) {
        return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6d59\u5546sdk\u5f02\u5e38\uff1a%1$s %2$s\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), e.getErrorCode(), e.getErrorParams());
    }

    public static String send(String serviceName, String traceNo, Map<String, Object> body) {
        return SdkInit.send(serviceName, traceNo, TokenService.getInstance().getToken(), body);
    }

    public static String send(String serviceName, String traceNo, String token, Map<String, Object> body) {
        logger.info("\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a{}", (Object)traceNo);
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", body);
        try {
            ApiHeader header = new ApiHeader();
            header.setMsgtype(serviceName);
            header.setTraceno(traceNo);
            header.setToken(token);
            ApiRspData data = ServiceBean.getService((String)SdkInit.getTenantKey()).invoke(header, body);
            String resultCode = data.getResultcode();
            String resultDesc = data.getResultdesc();
            if (!"000000".equalsIgnoreCase(resultCode)) {
                TokenService.clearToken(resultDesc);
            }
            return SdkInit.receive(data);
        }
        catch (SdkException e) {
            TokenService.clearToken(e);
            throw EBExceiptionUtil.serviceException((String)SdkInit.sdkError(e), (Throwable)e);
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String receive(ApiRspData data) {
        String rspStr = JSON.toJSONString((Object)data);
        logger.info("\u6d59\u5546\u8fd4\u56de\u62a5\u6587\uff1a{}" + rspStr);
        return rspStr;
    }

    public static String getURL() {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        if (StringUtils.isNotEmpty((String)port)) {
            String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
            port = "HTTPS".equals(protocol) && "443".equals(port) ? "" : ("HTTP".equals(protocol) && "80".equals(port) ? "" : ":" + port);
            return protocol + "://" + ip + port + RequestContextUtils.getBankParameterValue((String)"exchangeUri") + "/";
        }
        if (StringUtils.isEmpty((String)ip)) {
            return RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.baseurl);
        }
        return ip;
    }

    public static String getFileURL() {
        String ip = RequestContextUtils.getBankParameterValue((String)"fileurl");
        String port = RequestContextUtils.getBankParameterValue((String)"filePort");
        if (StringUtils.isNotEmpty((String)port)) {
            String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
            port = "HTTPS".equals(protocol) && "443".equals(port) ? "" : ("HTTP".equals(protocol) && "80".equals(port) ? "" : ":" + port);
            return protocol + "://" + ip + port + RequestContextUtils.getBankParameterValue((String)"file_uri") + "/";
        }
        return ip;
    }

    public static void init() {
        String tenantKey = SdkInit.getTenantKey();
        EntAppConfig config = new EntAppConfig();
        String openid = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.openid);
        config.setOpenid(openid);
        String appid = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.appid);
        config.setAppid(appid);
        String appkey = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.appkey);
        config.setAppkey(appkey);
        String baseurl = SdkInit.getURL();
        config.setBaseurl(baseurl);
        String fileurl = SdkInit.getFileURL();
        config.setFileurl(fileurl);
        try {
            config.setCfcafile(SdkInit.getCfcaKey());
            String pwd = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.cfcaAcnum);
            config.setCfcapwd(pwd);
            config.setCerfile(SdkInit.getCerKey());
            ServiceBean.getService((EntAppConfig)config, (String)tenantKey);
            logger.info("\u6d59\u5546sdk\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Throwable e) {
            logger.error("\u53c2\u6570\u521d\u59cb\u5316\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6d59\u5546sdk\u53c2\u6570\u521d\u59cb\u5316\u5f02\u5e38\uff1a%1$s\u3002", (String)"SdkInit_3", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static String getTenantKey() {
        return String.format("%s-%s", RequestContextUtils.getCustomId(), RequestContextUtils.getRequestContext().getBankLoginID());
    }

    public static byte[] getCfcaKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(ZsbOpaMetaDataImpl.cfcafile, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u79c1\u94a5\u8bc1\u4e66\u3002", (String)"SdkInit_1", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = SdkInit.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return fileContent;
    }

    public static byte[] getCerKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(ZsbOpaMetaDataImpl.cerfile, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u516c\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u516c\u94a5\u8bc1\u4e66\u3002", (String)"SdkInit_2", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = SdkInit.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return fileContent;
    }

    public static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }
}

