/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.ecny.proxy;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FrontProxy
extends AbstractImpl {
    public Element createHead(String bizType) {
        return this.createHead(bizType, Sequence.genSequence());
    }

    public Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"FrontProxy_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    public String sendAndRecvMsg(String rqstStr, String bizSeqId) {
        String rspStr = "";
        try {
            ConnectionFactory factory = this.getConnectionFactory();
            IConnection connection = this.getFrontProxyConnection(factory);
            this.openConnection(connection);
            try (OutputStream os = this.getOutputStream(connection);){
                this.send(os, rqstStr);
                try (InputStream is = this.getInputStream(connection);){
                    rspStr = this.recv(is);
                    this.closeOutputStreamQuietly(os);
                    this.closeInputStreamQuietly(is);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return rspStr;
    }
}

