/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdnxs.dc.services.payment.same;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Packer;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QrySamePayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QrySamePayImpl.class);
    private static final String TRANCODE = "B2ETrsResQryByERPJnlNo";

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)GDNXS_Packer.buildHead(TRANCODE, paymentInfo.getBankBatchSeqId()));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"JnlNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)ebank_root, (String)encoding);
        return requestMessage;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        Element list;
        List lists;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)s, (String)encoding);
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = GDNXS_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if (!"000000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QrySamePayImpl_0", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        if ((lists = (list = body.getChild("List")).getChildren("Map")).size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QrySamePayImpl_0", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            for (Element element : lists) {
                String ListNo = element.getChildText("ListNo");
                PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)ListNo);
                if (paymentInfo == null) {
                    logger.info("\u627e\u4e0d\u5230\u8be5\u4ed8\u6b3e\u6570\u636e\uff1a" + ListNo);
                    continue;
                }
                String returnCode = JDomUtils.getChildText((Element)element, (String)"TransResult");
                logger.info("\u8fd4\u56de\u7801\u4e3a\uff1a" + returnCode + "--" + bankStatus);
                if ("0".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QrySamePayImpl_1", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]), (String)bankStatus, (String)"");
                    continue;
                }
                if ("1".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QrySamePayImpl_2", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]), (String)bankStatus, (String)"");
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QrySamePayImpl_0", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]), (String)bankStatus, (String)"");
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return TRANCODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u540c\u884c\u8f6c\u8d26", (String)"QrySamePayImpl_3", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/B2ETrsResQryByERPJnlNo.do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("userPassword")).append("&SIGDATA=0");
        factory.setUri(sb.toString());
    }
}

