package kd.ebg.aqap.banks.jxnsb.cmp.services;
import kd.bos.dataentity.resource.ResManager;

import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Element;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Common {
    private final static EBGLogger log = EBGLogger.getInstance().getLogger(Common.class);

    /**
     * 返回包头+包体，完整待发送报文
     *
     * @param xml
     * @return
     */

    public static String createCommonMsg(String xml) {
        // "12347     00<ap><head>..."
        int digital = 10; // 记录包体长度数位,可以考虑设置为常量

        //拼接完整包体,报体为2个字节+数据报文，前一个字节表示加密标志（0：不加密，1：加密），后一个字节为保留位（用‘0’表示）。
        String msgBody = Constants.MSG_IsEncrypt + Constants.MSG_Reserved + xml;
        int msgBodyLen = getLength(msgBody); // 包体字符信息长度
        // "12347     "右补空格
        String msgHead = formatLen(String.valueOf(msgBodyLen), digital);
        return msgHead + msgBody;
    }

    public static int getLength(String str) {
        String encoding = getEncoding();
        try {
            int length = str.getBytes(encoding).length;
            return length;
        } catch (Exception e) {
            log.error("获取字符串长度出错：" + str + ", encoding:" + encoding, e);
        }
        return 0;
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen(msgLen, len, true, '0', getEncoding());
        } catch (Exception e) {
            log.error("格式化字符串出错。", e);
        }
        return "";
    }

    public static String getEncoding() {
        return RequestContextUtils.getBankParameterValue(BankLoginConfigUtil.CHARSET);
    }

    //
   /* private static byte[] read(DataInputStream dis, int length) {
        byte[] bytes = new byte[length];
        try {
            int result = dis.read(bytes);
            if (result - length != 0) {
                log.info("目标读取长度:" + length + ", 实际读取长度:" + result);
            }
        } catch (IOException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString("读取流失败,IOException", "Common_0", "ebg-aqap-banks-jxnsb-cmp") , e);
        }
        return bytes;
    }
*/
    /*private static String read2String(DataInputStream dis, int length,
                                      String encoding) {
        try {
            String str = new String(read(dis, length), encoding);
            if (StringUtils.isEmpty(str)) {
                str = "";
            } else {
                str = str.trim();
            }
            return str;
        } catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString("不支持%s字符编号。", "Common_4", "ebg-aqap-banks-jxnsb-cmp") , encoding), e);
        }
    }*/


  /*  public static String recvMessage(InputStream inputStream) {
        String encoding = RequestContextUtils.getCharset();
        try {
            DataInputStream dis = new DataInputStream(inputStream);

            String length = read2String(dis, 10, encoding);
            int len = Integer.parseInt(length);

            String str = read2String(dis, 2, encoding);  //2

            String xmlString = read2String(dis, len - 2, encoding); //数据报文
            log.info("##接收报文长度：" + length + ", 报体前两字节：" + str + ", 报体内容：" + xmlString);
            return xmlString;
        } catch (Exception e) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString("接收数据异常%s", "Common_5", "ebg-aqap-banks-jxnsb-cmp") , e.getMessage()), e);
        }
    }
*/
    /**
     * 从第12位截取报文正文
     *
     * @param input
     * @return
     */
    public static String parseRecvMsg(String input) {
        if (!StringUtils.isEmpty(input)) {
            return input.substring(12);
        }
        return "";
    }

    /*
     * 检查银行返回码，失败就直接抛出异常
     */
    public static BankResponse parseBankResponse(Element head) {
        BankResponse response = new BankResponse();

        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");

        String responseMessage = ret_info;
        if (!StringUtils.isEmpty(ext_info)) {
            responseMessage += "_" + ext_info;
        }


        response.setResponseCode(succ_flag + "_" + ret_code);
        response.setResponseMessage(responseMessage);


        return response;
    }

}
