/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.ParserUtil;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.ebg.egf.common.codeless.dateUtil.LocalDateTimeUtil;
import kd.ebg.egf.common.codeless.dateUtil.LocalDateUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MapToObjectUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(MapToObjectUtil.class);

    public static Object mapToObject(Map<String, String> map, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (map == null) {
            return null;
        }
        Object object = beanClass.newInstance();
        for (Field field : fields = beanClass.getDeclaredFields()) {
            Comparable<ChronoLocalDate> result;
            String value;
            int mod = field.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
            ReflectionUtils.makeAccessible((Field)field);
            Class<?> fieldType = field.getType();
            if (fieldType.equals(String.class)) {
                if (StringUtils.isEmpty(map.get(field.getName()))) {
                    field.set(object, "");
                    continue;
                }
                field.set(object, map.get(field.getName()));
                continue;
            }
            if (fieldType.equals(Integer.TYPE)) {
                if (StringUtils.isEmpty(map.get(field.getName()))) {
                    field.set(object, "0");
                    continue;
                }
                field.set(object, Integer.parseInt(map.get(field.getName())));
                continue;
            }
            if (fieldType.equals(LocalDate.class)) {
                value = map.get(field.getName());
                if (!StringUtils.isNotEmpty(value) || (result = LocalDateUtil.tryParse(value)) == null) continue;
                field.set(object, result);
                continue;
            }
            if (fieldType.equals(Double.class)) {
                if (StringUtils.isEmpty(map.get(field.getName()))) {
                    field.set(object, Double.parseDouble("0"));
                    continue;
                }
                field.set(object, Double.parseDouble(map.get(field.getName())));
                continue;
            }
            if (fieldType.equals(Double.TYPE)) {
                if (StringUtils.isEmpty(map.get(field.getName()))) {
                    field.set(object, Double.parseDouble("0"));
                    continue;
                }
                field.set(object, Double.parseDouble(map.get(field.getName())));
                continue;
            }
            if (fieldType.equals(Integer.class)) {
                field.set(object, Integer.parseInt(map.get(field.getName())));
                continue;
            }
            if (fieldType.equals(BigDecimal.class)) {
                field.set(object, new BigDecimal(map.get(field.getName())));
                continue;
            }
            if (!fieldType.equals(LocalDateTime.class) || !StringUtils.isNotEmpty(value = map.get(field.getName())) || (result = LocalDateTimeUtil.tryParse(value)) == null) continue;
            field.set(object, result);
        }
        return object;
    }

    public static Map<String, String> coventMap(Map eachData, Map reflect) {
        HashMap<String, String> result = new HashMap<String, String>(1);
        Set set2 = reflect.keySet();
        set2.stream().forEach(key -> {
            String value = (String)eachData.get(reflect.get(key));
            result.put((String)key, value);
        });
        return result;
    }
}

