/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.ParserUtil;

public class PathUtil {
    private static final String PATH_SEPARATOR = "\\.";

    public static String getRelativePath(String longPath, String shortPath) {
        String[] shortNodes;
        if (longPath == null || shortPath == null) {
            throw new IllegalArgumentException("Paths cannot be null");
        }
        String[] longNodes = longPath.split(PATH_SEPARATOR);
        if (longNodes.length <= (shortNodes = shortPath.split(PATH_SEPARATOR)).length) {
            throw new IllegalArgumentException("Long path must be longer than short path");
        }
        for (int i = 0; i < shortNodes.length; ++i) {
            if (shortNodes[i].equals(longNodes[i])) continue;
            throw new IllegalArgumentException("Short path must be a prefix of long path");
        }
        StringBuilder relativePath = new StringBuilder();
        relativePath.append(shortNodes[shortNodes.length - 1]);
        for (int i = shortNodes.length; i < longNodes.length; ++i) {
            relativePath.append(".").append(longNodes[i]);
        }
        return relativePath.toString();
    }

    public static String getLastNode(String path) {
        int lastDotIndex;
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        path = path.trim();
        if ((path = path.replaceAll("\\.+", ".")).endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((lastDotIndex = path.lastIndexOf(".")) == -1) {
            return path;
        }
        return path.substring(lastDotIndex + 1);
    }

    public static int getNodeCount(String path) {
        if (path == null || path.trim().isEmpty()) {
            return 0;
        }
        path = path.trim();
        if ((path = path.replaceAll("\\.+", ".")).endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            return 0;
        }
        return path.split(PATH_SEPARATOR).length;
    }
}

