/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.IConnection;

public class TcpConnection
implements IConnection {
    private Socket socket;
    private String host;
    private int port;
    private int timeout;

    public TcpConnection(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    @Override
    public void openConnection() throws IOException {
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(this.timeout * 60 * 1000);
        }
        catch (IOException e) {
            throw new ConnectException(String.format(ResManager.loadKDString((String)"\u4e0e\u524d\u7f6e\u673a\u5efa\u7acbtcp\u8fde\u63a5\u5f02\u5e38\u3002", (String)"TcpConnection_0", (String)"ebg-egf-common", (Object[])new Object[0]), this.host + ":" + this.port));
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.verifyConnection();
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.verifyConnection();
        return this.socket.getOutputStream();
    }

    protected void shutdownOutput() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.shutdownOutput();
        }
    }

    @Override
    public int getResponseCode() throws IOException {
        this.verifyConnection();
        return 200;
    }

    @Override
    public void closeConnection() {
        if (Objects.nonNull(this.socket)) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(ResManager.loadKDString((String)"\u5173\u95ed socket \u8fde\u63a5\u5931\u8d25", (String)"TcpConnection_1", (String)"ebg-egf-common", (Object[])new Object[0]), e);
            }
        }
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("tcp://").append(this.host).append(':').append(this.port);
        return sb.toString();
    }

    private void verifyConnection() {
        if (Objects.isNull(this.socket)) {
            throw new IllegalStateException(ResManager.loadKDString((String)"socket\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u8c03\u7528IConnection\u7684openConnection\u65b9\u6cd5\u3002", (String)"TcpConnection_2", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        if (this.socket.isClosed()) {
            throw new IllegalStateException(ResManager.loadKDString((String)"socket \u5df2\u7ecf\u5173\u95ed", (String)"TcpConnection_3", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        if (!this.socket.isConnected()) {
            throw new IllegalStateException(ResManager.loadKDString((String)"socket \u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00\u3002", (String)"TcpConnection_4", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
    }
}

