/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.factory;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import kd.ebg.egf.common.cache.CacheProperties;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.framework.security.api.EBConstants;
import kd.ebg.egf.common.framework.security.api.ICustomerInfoProvider;
import kd.ebg.egf.common.framework.security.api.IEBSecurityProvider;
import kd.ebg.egf.common.framework.security.atomic.IEncrypt;
import kd.ebg.egf.common.framework.security.factory.DataBaseCustomerInfoProvider;
import kd.ebg.egf.common.framework.security.factory.DefaultEBSecurityProvider;
import kd.ebg.egf.common.framework.security.factory.EBKeyProvider;
import kd.ebg.egf.common.framework.security.factory.EBSecurityFactory;
import kd.ebg.egf.common.model.tenant.CustomerInfo;

public class EBSecurityProviderFactory {
    private final Cache<String, IEncrypt> customerPublicKeyEncryptCache;
    private final Cache<String, IEBSecurityProvider> providerCache;
    private ICustomerInfoProvider customerInfoProvider;
    private IEncrypt ebEncrypt;
    private EBKeyProvider ebKeyProvider = EBKeyProvider.getInstance();
    private static EBSecurityProviderFactory instance = new EBSecurityProviderFactory();

    public static EBSecurityProviderFactory getInstance() {
        return instance;
    }

    public EBSecurityProviderFactory() {
        CacheProperties properties = CacheProperties.getInstance();
        this.customerInfoProvider = new DataBaseCustomerInfoProvider();
        this.customerPublicKeyEncryptCache = CacheBuilder.newBuilder().initialCapacity(1000).concurrencyLevel(5).expireAfterWrite(properties.getPublicKeyExpire(), TimeUnit.SECONDS).build();
        this.providerCache = CacheBuilder.newBuilder().initialCapacity(1000).concurrencyLevel(5).expireAfterWrite(properties.getPublicKeyExpire(), TimeUnit.SECONDS).build();
    }

    public IEBSecurityProvider getProvider(EBBaseRequest request) {
        IEBSecurityProvider provider = (IEBSecurityProvider)this.providerCache.getIfPresent((Object)request.getCustomerID());
        if (null == provider) {
            provider = new DefaultEBSecurityProvider(this.customerInfoProvider, this.getEBPrivateKey(), this.getEBPublicKey());
            this.providerCache.put((Object)request.getCustomerID(), (Object)provider);
        }
        return provider;
    }

    public IEncrypt getCustomerPublicKeyEncrypt(String customerID) {
        IEncrypt encrypt = (IEncrypt)this.customerPublicKeyEncryptCache.getIfPresent((Object)customerID);
        if (null == encrypt) {
            CustomerInfo info = this.customerInfoProvider.getCustomerInfoByID(customerID);
            encrypt = EBSecurityFactory.INSTANCE.getEBEncrypt(EBConstants.KEY_ENCRYPT_ALGORITHM, null, info.getPublicKey());
            this.customerPublicKeyEncryptCache.put((Object)customerID, (Object)encrypt);
        }
        return encrypt;
    }

    private byte[] getEBPrivateKey() {
        return this.ebKeyProvider.getPrivateKey().getEncoded();
    }

    private byte[] getEBPublicKey() {
        return this.ebKeyProvider.getPublicKey().getEncoded();
    }

    public IEncrypt getEBEncrypt() {
        if (null == this.ebEncrypt) {
            this.ebEncrypt = this.getEBEncrypt(EBConstants.KEY_ENCRYPT_ALGORITHM);
        }
        return this.ebEncrypt;
    }

    private IEncrypt getEBEncrypt(String algorithm) {
        IEncrypt encrypt = EBSecurityFactory.INSTANCE.getEBEncrypt(algorithm, this.getEBPrivateKey(), null);
        return encrypt;
    }
}

