/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.service.file;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.repository.file.PayAttachmentRepository;

public class PayAttachmentService {
    private static PayAttachmentService instance = new PayAttachmentService();
    private PayAttachmentRepository payAttachmentRepository = PayAttachmentRepository.getInstance();

    public static PayAttachmentService getInstance() {
        return instance;
    }

    public List<PayAttachment> findAttachmentsByStatusId(List<Integer> attachmentStates) {
        return this.payAttachmentRepository.findAttachmentsByStatusId(attachmentStates);
    }

    public void saveAttachments(List<PayAttachment> lists) {
        TXHandle h = TX.requiresNew();
        try {
            this.payAttachmentRepository.saveAll(lists);
        }
        catch (Exception ex) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8de8\u5883\u4ed8\u6b3e\u9644\u4ef6\u8bb0\u5f55\u5199\u5165\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38", (String)"AttachmentService_0", (String)"ebg-egf-common", (Object[])new Object[0]), ex);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public List<PayAttachment> findByBankBatchSeqId(String bankBatchSeqId) {
        return this.payAttachmentRepository.findByBankBatchSeqId(bankBatchSeqId);
    }

    public void updateAll(List<PayAttachment> lists) {
        TXHandle h = TX.requiresNew();
        try {
            this.payAttachmentRepository.updateAll(lists);
        }
        catch (Exception ex) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8de8\u5883\u4ed8\u6b3e\u9644\u4ef6\u8bb0\u5f55\u5199\u5165\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38", (String)"AttachmentService_0", (String)"ebg-egf-common", (Object[])new Object[0]), ex);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

