/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.license.old.Coder;
import kd.ebg.egf.common.license.old.LicenseFileErrorException;
import kd.ebg.egf.common.license.old.LicenseKey;
import kd.ebg.egf.common.license.old.Utils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LicenseUtil {
    private static final LicenseKey licenseKey = LicenseKey.getInstance();

    public static String decrypt(String label, String dest, boolean isValidate) throws LicenseFileErrorException {
        return LicenseUtil.decrypt(label, dest, isValidate, true);
    }

    public static String decrypt(String label, String dest, boolean isValidate, boolean isCheckHash) throws LicenseFileErrorException {
        if (dest == null) {
            return "";
        }
        List<byte[]> list = LicenseUtil.getCheckedEnrypted(label, dest, isValidate, isCheckHash);
        StringBuilder plaintext = new StringBuilder();
        for (byte[] value : list) {
            plaintext.append(StringUtils.byteToString(licenseKey.getCa().decrypt(value)));
        }
        return plaintext.toString();
    }

    public static String encryptAES(String source) throws LicenseFileErrorException {
        if (StringUtils.isEmpty(source)) {
            return "";
        }
        try {
            String c = Utils.encode(licenseKey.getAes().encrypt(source.getBytes("ISO8859-1")));
            return c;
        }
        catch (Exception e) {
            throw new LicenseFileErrorException(1000, (Throwable)e);
        }
    }

    public static String decryptAES(String source) throws LicenseFileErrorException {
        if (StringUtils.isEmpty(source)) {
            return "";
        }
        try {
            byte[] b = licenseKey.getAes().decrypt(Utils.decode(source));
            String rs = StringUtils.byteToString(b);
            return rs;
        }
        catch (Exception e) {
            throw new LicenseFileErrorException(1000, (Throwable)e);
        }
    }

    private static List<byte[]> getCheckedEnrypted(String label, String pStr, boolean isValidate, boolean isCheckHash) throws LicenseFileErrorException {
        if (isCheckHash) {
            pStr = LicenseUtil.checkHash(label, pStr, isValidate);
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>(16);
        int split = 5468;
        int n = pStr.length() / split;
        int m = pStr.length() % split;
        for (int i = 0; i < n; ++i) {
            String part = pStr.substring(0, split);
            if (i != n - 1 || m > 0) {
                pStr = pStr.substring(split);
            }
            list.add(LicenseUtil.checkLength(label, part));
        }
        if (m > 0) {
            list.add(LicenseUtil.checkLength(label, pStr));
        }
        return list;
    }

    private static byte[] checkLength(String label, String pStr) throws LicenseFileErrorException {
        int len = pStr.length();
        String enryptedPart = pStr.substring(0, len - 4);
        String enryptedSize = pStr.substring(len - 4);
        byte[] encryptedData = null;
        int cipherLen = 0;
        try {
            cipherLen = Integer.parseInt(enryptedSize);
            enryptedPart = Utils.hexStr2Str(enryptedPart);
            encryptedData = Coder.decryptBASE64(enryptedPart);
            if (cipherLen % 128 != 0) {
                throw new LicenseFileErrorException(1000, label);
            }
            if (encryptedData.length < cipherLen) {
                throw new LicenseFileErrorException(1000, label);
            }
        }
        catch (Exception e) {
            throw new LicenseFileErrorException(1000, label, e);
        }
        return Utils.arrayCopyOf(encryptedData, cipherLen);
    }

    static String checkHash(String label, String pStr, boolean isValidate) throws LicenseFileErrorException {
        String hashValue;
        int len = pStr.length();
        if (len <= 16) {
            throw new LicenseFileErrorException(1000, label);
        }
        String enryptedPart = pStr.substring(0, len - 16);
        String hashPart = pStr.substring(len - 16);
        if (!hashPart.equals((hashValue = LicenseUtil.hash(enryptedPart, isValidate)).substring(0, 16))) {
            throw new LicenseFileErrorException(1000, label);
        }
        return enryptedPart;
    }

    public static String hash(String source, boolean isValidate) {
        source = isValidate ? source + licenseKey.getVALIDATE_CIPHER() : source + licenseKey.getORIGINAL_CIPHER();
        return Utils.hash(licenseKey.getHa(), source);
    }

    public static String hash(String source) {
        return Utils.hash(licenseKey.getHa(), source);
    }
}

