/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.ebg.egf.common.framework.service.license.LicenseDetailService;
import kd.ebg.egf.common.license.TenantInfo;
import kd.ebg.egf.common.model.license.LicenseDetail;
import kd.ebg.egf.common.model.license.LicenseFile;
import kd.ebg.egf.common.repository.license.LicenseFileRepository;

public class OldLicenseCache {
    public static TenantInfo getTenant() {
        return OldLicenseCache.createTenant();
    }

    private static TenantInfo createTenant() {
        RequestContext current = RequestContext.get();
        List<LicenseDetail> lists = OldLicenseCache.loadBankLoginInfoExcludeNote(current);
        String tenantId = current.getTenantId();
        LicenseFileRepository licenseFileRepository = LicenseFileRepository.getInstance();
        LicenseFile licenseFile = licenseFileRepository.findByCustomId(tenantId);
        TenantInfo tenant = new TenantInfo();
        if (licenseFile != null) {
            tenant.setTotalLicenseCount(licenseFile.getLicenseCount());
            tenant.setUnusedLicenseCount(licenseFile.getLicenseCount());
            tenant.setExpiredDate(licenseFile.getExpireTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        lists.forEach(s -> {
            int used = tenant.deductLicense();
            tenant.setUsedLicenseCount(used);
        });
        tenant.setInfos(lists);
        return tenant;
    }

    private static List<LicenseDetail> loadBankLoginInfoExcludeNote(RequestContext current) {
        String tenantId = current.getTenantId();
        LicenseDetailService licenseDetailService = LicenseDetailService.getInstance();
        List<LicenseDetail> lists = licenseDetailService.findLicenseDetailByCustomIdExcludeNote(tenantId);
        return lists;
    }
}

