/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import javax.crypto.Cipher;
import kd.ebg.egf.common.license.old.Coder;
import kd.ebg.egf.common.log.EBGLogger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSACoder {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(RSACoder.class);
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";

    public static byte[] getDeCryptData(byte[] data, Cipher cipher) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
        int blockSize = 128;
        int j = 0;
        int inputLen = data.length;
        while (inputLen - j * blockSize > 0) {
            byte[] srcbyte = cipher.doFinal(data, j * blockSize, blockSize);
            bout.write(srcbyte);
            ++j;
        }
        byte[] decryptedData = bout.toByteArray();
        bout.close();
        return decryptedData;
    }

    public static byte[] getEnCryptData(byte[] data, Cipher cipher) throws Exception {
        return cipher.doFinal(data);
    }

    public static Cipher getCipherByPublicKey(BigInteger e, BigInteger m, boolean isDecrypt) throws Exception {
        RSAPublicKeySpec rsakey = new RSAPublicKeySpec(m, e);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(rsakey);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/ECB/pkcs1padding", (Provider)new BouncyCastleProvider());
            if (isDecrypt) {
                cipher.init(2, publicKey);
            } else {
                cipher.init(1, publicKey);
            }
        }
        catch (Exception exception) {
            logger.error("\u83b7\u53d6\u5bc6\u94a5\u5f02\u5e38", e);
        }
        return cipher;
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = Coder.decryptBASE64(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(data);
        return Coder.encryptBASE64(signature.sign());
    }

    public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return Coder.encryptBASE64(key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return Coder.encryptBASE64(key.getEncoded());
    }
}

