/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

import java.math.BigInteger;
import javax.crypto.Cipher;
import kd.ebg.egf.common.license.old.Coder;
import kd.ebg.egf.common.license.old.CryptoAlgorithm;
import kd.ebg.egf.common.license.old.RSACoder;
import kd.ebg.egf.common.license.old.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACryptoAlgorithm
implements CryptoAlgorithm {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.eas.base.license.file.RSACryptoAlgorithm");
    Cipher decryptCipher;
    Cipher encryptCipher;

    RSACryptoAlgorithm(String pubkey) {
        try {
            byte[] base64key = Coder.decryptBASE64(pubkey);
            String encodekey = new String(base64key);
            byte[] key = Utils.decode(encodekey);
            byte[] modulus = Utils.arrayCopyOfRange(key, 0, 128);
            byte[] exponent = Utils.arrayCopyOfRange(key, 128, 256);
            BigInteger m = new BigInteger(1, modulus);
            BigInteger e = new BigInteger(1, exponent);
            this.decryptCipher = RSACoder.getCipherByPublicKey(e, m, true);
            this.encryptCipher = RSACoder.getCipherByPublicKey(e, m, false);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new Error("Failed to initialize RSA PUBKYE", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        byte[] encoded = null;
        try {
            encoded = RSACoder.getEnCryptData(bytes, this.encryptCipher);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return encoded;
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        byte[] decoded = null;
        try {
            decoded = RSACoder.getDeCryptData(bytes, this.decryptCipher);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return decoded;
    }
}

