/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.log;

import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.log.LogPrivacyService;
import kd.ebg.egf.common.log.LogPrivacy;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LogPrivacyUtil {
    public static String getSendResult(String sendMsg) {
        if (StringUtils.isEmpty(sendMsg)) {
            return sendMsg;
        }
        EBContext context = EBContext.getContext();
        String bankVersion = context.getBankVersionID();
        if (StringUtils.isEmpty(bankVersion)) {
            return sendMsg;
        }
        List<LogPrivacy> keyWords = LogPrivacyService.getInstance().getKeyWords(bankVersion);
        if (keyWords == null || keyWords.size() == 0) {
            return sendMsg;
        }
        for (LogPrivacy logPrivacy : keyWords) {
            if ("xml".equals(logPrivacy.getType())) {
                sendMsg = LogPrivacyUtil.getXmlLog(sendMsg, logPrivacy.getBankKey());
                continue;
            }
            if (!"json".equals(logPrivacy.getType())) continue;
            sendMsg = LogPrivacyUtil.getJsonLog(sendMsg, logPrivacy.getBankKey());
        }
        return sendMsg;
    }

    public static String getXmlLog(String sendMsg, String bankKey) {
        int startNo = sendMsg.indexOf("<" + bankKey + ">");
        int endNo = sendMsg.indexOf("</" + bankKey + ">");
        if (startNo == -1 || endNo == -1) {
            return sendMsg;
        }
        String target = sendMsg.substring(startNo, endNo);
        if (StringUtils.isEmpty(target)) {
            return sendMsg;
        }
        if (target.contains("<![CDATA[")) {
            String regix = "<" + bankKey + ">******";
            String before = sendMsg.substring(0, startNo);
            String end = sendMsg.substring(endNo);
            sendMsg = before + regix + end;
        } else {
            String regix = "<" + bankKey + ">\\*\\*\\*\\*\\*\\*";
            sendMsg = sendMsg.replaceAll(target, regix);
        }
        return sendMsg;
    }

    public static String getJsonLog(String sendMsg, String bankKey) {
        String target = "\"" + bankKey + "\":\"";
        int startNo = sendMsg.indexOf(target);
        if (startNo == -1) {
            return sendMsg;
        }
        String temp = sendMsg.substring(startNo + target.length());
        int startNoContent = temp.indexOf(34);
        if (startNoContent == -1) {
            return sendMsg;
        }
        temp = temp.substring(0, startNoContent);
        target = "\"" + bankKey + "\":\"" + temp;
        sendMsg = sendMsg.replaceAll(target, "\"" + bankKey + "\":\"\\*\\*\\*\\*\\*\\*");
        return sendMsg;
    }

    public static void main(String[] args) {
    }
}

