/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.model.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.StringUtils;

public class Sort
implements Iterable<Order>,
Serializable {
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private static final Sort UNSORTED = Sort.By();
    private List<Order> orders;

    private Sort() {
    }

    private Sort(List<Order> orders) {
        this.orders = orders;
    }

    private Sort(Direction direction, List<String> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one property to sort by!");
        }
        this.orders = properties.stream().map(it -> new Order(direction, (String)it)).collect(Collectors.toList());
    }

    public static Sort unsorted() {
        return UNSORTED;
    }

    public static Sort By() {
        return new Sort();
    }

    public static Sort by(String ... properties) {
        Assert.notNull((Object)properties, (String)"Properties must not be null!");
        return properties.length == 0 ? Sort.unsorted() : new Sort(DEFAULT_DIRECTION, Arrays.asList(properties));
    }

    public static Sort by(List<Order> orders) {
        Assert.notNull(orders, (String)"Orders must not be null!");
        return orders.isEmpty() ? Sort.unsorted() : new Sort(orders);
    }

    public static Sort by(Order ... orders) {
        Assert.notNull((Object)orders, (String)"Orders must not be null!");
        return new Sort(Arrays.asList(orders));
    }

    @Override
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }

    public List<Order> toList() {
        return this.orders;
    }

    public static enum Direction {
        ASC,
        DESC;


        public boolean isAscending() {
            return this == ASC;
        }

        public boolean isDescending() {
            return this == DESC;
        }
    }

    public static class Order
    implements Serializable {
        public static final Direction DEFAULT_DIRECTION = Direction.ASC;
        private final Direction direction;
        private final String property;

        public Order(Direction direction, String property) {
            if (!StringUtils.hasText((String)property)) {
                throw new IllegalArgumentException("Property must not null or empty!");
            }
            this.direction = direction == null ? DEFAULT_DIRECTION : direction;
            this.property = property;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

