/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.bank;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.constant.BankTypeEnum;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankVersionRepository {
    private String ENTITY_NAME = "aqap_bank";
    private String SELECT_ALL_PROPERTIES = "id, number, name, custom_id, enable, bank_type, bank_name";
    private static BankVersionRepository instance = new BankVersionRepository();

    public static BankVersionRepository getInstance() {
        return instance;
    }

    public DynamicObject loadDynamicObjectByBankVersionID(String bankVersionID) {
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)this.ENTITY_NAME, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankVersionID)});
        return data;
    }

    public String getBankLocaleName(String bankVersionID) {
        String bankName = "";
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)this.ENTITY_NAME, (String)"id", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{bankVersionID}).toArray());
        for (Map.Entry map : dynamicObjectMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)map.getValue();
            bankName = dynamicObject.getLocaleString("name").getLocaleValue();
        }
        if (StringUtils.isEmpty(bankName)) {
            bankName = bankVersionID;
        }
        return bankName;
    }

    public DynamicObject loadDynamicObjectByID(Long id) {
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)this.ENTITY_NAME, (String)"id, number, name, bank_name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return data;
    }

    public DynamicObject[] loadDynamicObjects() {
        DynamicObject[] data = BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.SELECT_ALL_PROPERTIES, null);
        return data;
    }

    public DynamicObject[] loadEnableDynamicObjects() {
        DynamicObject[] data = BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return data;
    }

    public int countEnableBankVersion() {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, (String)"");){
            int total;
            int n = total = ds.count("id", false);
            return n;
        }
    }

    public boolean isForeignBank(String bankVersionID) {
        boolean isForeignBank = false;
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)this.ENTITY_NAME, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankVersionID)});
        if (data != null) {
            String bank_type = data.getString("bank_type");
            if (String.valueOf(BankTypeEnum.waizi.getValue()).equalsIgnoreCase(bank_type)) {
                isForeignBank = true;
            }
        }
        return isForeignBank;
    }

    public Map<Long, DynamicObject> getEnableBankMap() {
        HashMap<Long, DynamicObject> bankMap = new HashMap<Long, DynamicObject>(16);
        Map<Object, DynamicObject> maps = this.getEnabledBanks();
        for (Map.Entry<Object, DynamicObject> entry : maps.entrySet()) {
            DynamicObject dynamicObject = entry.getValue();
            Long id = dynamicObject.getLong("id");
            bankMap.put(id, dynamicObject);
        }
        return bankMap;
    }

    private Map<Object, DynamicObject> getEnabledBanks() {
        String entityName = "aqap_bank";
        QFilter filter = QFilter.of((String)"enable=?", (Object[])new Object[]{"1"});
        HashMap dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])filter.toArray());
        if (dynamicObjectMap == null) {
            dynamicObjectMap = new HashMap(1);
        }
        return dynamicObjectMap;
    }
}

