/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.repository.file;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayAttachmentRepository {
    private static PayAttachmentRepository instance = new PayAttachmentRepository();
    private String ATTACHMENT_ENTITY = "aqap_pay_attachment";
    private String SELECT_ALL_PROPERTIES = "id,custom_id,bank_login_id,bank_version_id,impl_class_name,query_impl_class_name,enable,status_id,status_name,status_msg,bank_status,bank_msg,bank_batch_seq_id,bank_detail_seq_id,download_url,file_path,file_id,file_name,reversed1,reversed2,reversed3,reversed4";

    public static PayAttachmentRepository getInstance() {
        return instance;
    }

    public List<PayAttachment> findAttachmentsByStatusId(List<Integer> attachmentStates) {
        if (CollectionUtil.isEmpty(attachmentStates)) {
            return Lists.newArrayList();
        }
        ArrayList<PayAttachment> list = new ArrayList<PayAttachment>(10);
        QFilter qFilter = new QFilter("status_id", "in", attachmentStates);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)this.ATTACHMENT_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])qFilter.toArray());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            list.add(this.transPayAttachment((DynamicObject)dynamicObjectCollection.get(i)));
        }
        return list;
    }

    public void saveAll(List<PayAttachment> details) {
        if (CollectionUtils.isNotEmpty(details)) {
            DynamicObject[] dynamicObjects = new DynamicObject[details.size()];
            for (int i = 0; i < details.size(); ++i) {
                dynamicObjects[i] = this.transDynamicObject(null, details.get(i));
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    private PayAttachment transPayAttachment(DynamicObject dynamicObject) {
        PayAttachment payAttachment = new PayAttachment();
        payAttachment.setId(dynamicObject.getString("id"));
        payAttachment.setCustomID(dynamicObject.getString("custom_id"));
        payAttachment.setBankLoginID(dynamicObject.getString("bank_login_id"));
        payAttachment.setBankVersionID(dynamicObject.getString("bank_version_id"));
        payAttachment.setImplClassName(dynamicObject.getString("impl_class_name"));
        payAttachment.setQueryImplClassName(dynamicObject.getString("query_impl_class_name"));
        payAttachment.setEnable(dynamicObject.getInt("enable"));
        payAttachment.setStatus(dynamicObject.getInt("status_id"));
        payAttachment.setStatusName(dynamicObject.getString("status_name"));
        payAttachment.setStatusMsg(dynamicObject.getString("status_msg"));
        payAttachment.setBankStatus(dynamicObject.getString("bank_status"));
        payAttachment.setBankMsg(dynamicObject.getString("bank_msg"));
        payAttachment.setBankBatchSeqID(dynamicObject.getString("bank_batch_seq_id"));
        payAttachment.setBankDetailSeqID(dynamicObject.getString("bank_detail_seq_id"));
        payAttachment.setDownloadUrl(dynamicObject.getString("download_url"));
        payAttachment.setFilePath(dynamicObject.getString("file_path"));
        payAttachment.setFileID(dynamicObject.getString("file_id"));
        payAttachment.setFileName(dynamicObject.getString("file_name"));
        payAttachment.setReversed1(dynamicObject.getString("reversed1"));
        payAttachment.setReversed2(dynamicObject.getString("reversed2"));
        payAttachment.setReversed3(dynamicObject.getString("reversed3"));
        payAttachment.setReversed4(dynamicObject.getString("reversed4"));
        return payAttachment;
    }

    private DynamicObject transDynamicObject(DynamicObject dynamicObject, PayAttachment payAttachment) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ATTACHMENT_ENTITY);
        }
        if (StringUtils.isNotEmpty(payAttachment.getId())) {
            this.setDynamicParamater(dynamicObject, "id", payAttachment.getId());
        }
        this.setDynamicParamater(dynamicObject, "custom_id", payAttachment.getCustomID());
        this.setDynamicParamater(dynamicObject, "bank_login_id", payAttachment.getBankLoginID());
        this.setDynamicParamater(dynamicObject, "bank_version_id", payAttachment.getBankVersionID());
        this.setDynamicParamater(dynamicObject, "impl_class_name", payAttachment.getImplClassName());
        this.setDynamicParamater(dynamicObject, "query_impl_class_name", payAttachment.getQueryImplClassName());
        this.setDynamicParamater(dynamicObject, "enable", payAttachment.getEnable());
        this.setDynamicParamater(dynamicObject, "status_id", payAttachment.getStatus());
        this.setDynamicParamater(dynamicObject, "status_name", payAttachment.getStatusName());
        this.setDynamicParamater(dynamicObject, "status_msg", payAttachment.getStatusMsg());
        this.setDynamicParamater(dynamicObject, "bank_status", payAttachment.getBankStatus());
        this.setDynamicParamater(dynamicObject, "bank_msg", payAttachment.getBankMsg());
        this.setDynamicParamater(dynamicObject, "bank_batch_seq_id", payAttachment.getBankBatchSeqID());
        this.setDynamicParamater(dynamicObject, "bank_detail_seq_id", payAttachment.getBankDetailSeqID());
        this.setDynamicParamater(dynamicObject, "download_url", payAttachment.getDownloadUrl());
        this.setDynamicParamater(dynamicObject, "file_path", payAttachment.getFilePath());
        this.setDynamicParamater(dynamicObject, "file_id", payAttachment.getFileID());
        this.setDynamicParamater(dynamicObject, "file_name", payAttachment.getFileName());
        this.setDynamicParamater(dynamicObject, "reversed1", payAttachment.getReversed1());
        this.setDynamicParamater(dynamicObject, "reversed2", payAttachment.getReversed2());
        this.setDynamicParamater(dynamicObject, "reversed3", payAttachment.getReversed3());
        this.setDynamicParamater(dynamicObject, "reversed4", payAttachment.getReversed4());
        if (payAttachment.getInsertTime() == null) {
            Date insertTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            this.setDynamicParamater(dynamicObject, "createtime", insertTime);
        } else {
            this.setDynamicParamater(dynamicObject, "createtime", LocalDateUtil.localDateTime2Date(payAttachment.getInsertTime()));
        }
        this.setDynamicParamater(dynamicObject, "modifytime", Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        return dynamicObject;
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)value)) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }

    public List<PayAttachment> findByBankBatchSeqId(String bankBatchSeqId) {
        ArrayList<PayAttachment> list = new ArrayList<PayAttachment>(10);
        QFilter qFilter = QFilter.of((String)"bank_batch_seq_id = ?", (Object[])new Object[]{bankBatchSeqId});
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)this.ATTACHMENT_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])qFilter.toArray());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            list.add(this.transPayAttachment((DynamicObject)dynamicObjectCollection.get(i)));
        }
        return list;
    }

    public void updateAll(List<PayAttachment> lists) {
        if (CollectionUtils.isNotEmpty(lists)) {
            int len = lists.size();
            Object[] pks = new Object[len];
            for (int i = 0; i < len; ++i) {
                pks[i] = Long.parseLong(lists.get(i).getId());
            }
            DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)this.ATTACHMENT_ENTITY).getDynamicObjectType();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)type);
            for (int i = 0; i < len; ++i) {
                PayAttachment payAttachment = lists.get(i);
                dynamicObjects[i] = this.transDynamicObject(dynamicObjects[i], payAttachment);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }
}

