/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.repository.BankIncreasingSequenceRepository;

public class BankIncreasingSequenceUtil {
    private static BankIncreasingSequenceRepository bankIncreasingSequenceRepository = BankIncreasingSequenceRepository.getInstance();

    private static long getBankSerialNo(String key) {
        DLock lock = DLock.create((String)key);
        try {
            if (lock.tryLock()) {
                String queryDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                DynamicObject dynamicObject = bankIncreasingSequenceRepository.getBankSerialNo(key, queryDate);
                if (dynamicObject != null && 0L != dynamicObject.getLong("sequence_no")) {
                    long sequence_no = dynamicObject.getLong("sequence_no");
                    dynamicObject.set("sequence_no", (Object)(++sequence_no));
                    bankIncreasingSequenceRepository.update(dynamicObject);
                    long l = sequence_no;
                    return l;
                }
                bankIncreasingSequenceRepository.init(key);
                long l = 1L;
                return l;
            }
            long queryDate = 0L;
            return queryDate;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException(e.getMessage(), e);
        }
        finally {
            lock.unlock();
        }
    }

    public static long getIncreasingSequence(String key) {
        int i = 1;
        do {
            long sequence_no;
            if ((sequence_no = BankIncreasingSequenceUtil.getBankSerialNo(key)) > 0L) {
                return sequence_no;
            }
            ++i;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw EBExceiptionUtil.serviceException(e.getMessage(), e);
            }
        } while (i <= 50);
        throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u83b7\u53d6\u81ea\u589e\u5e8f\u5217\u53f7\u5f02\u5e38\uff0c\u91cd\u8bd550\u6b21\u4ecd\u65e0\u6cd5\u83b7\u53d6\u5230\u7ed3\u679c\u3002", (String)"BankIncreasingSequenceUtil_0", (String)"ebg-egf-common", (Object[])new Object[0]));
    }
}

