/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.utils.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.ReflectionUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.NumberUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public final class FieldUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FieldUtils.class);
    private static final String SEPARATOR = "_";
    private static final Set<Class<?>> basicClass = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, Long.TYPE, String.class, Boolean.class, Byte.class, Short.class, Integer.class, Float.class, Double.class, Long.class, Date.class, LocalDate.class, LocalTime.class, LocalDateTime.class, BigDecimal.class, Instant.class});
    static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HHmmss");
    static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    static Set<Class<?>> supportConvertType = Sets.newHashSet((Object[])new Class[]{LocalDate.class, LocalTime.class, LocalDateTime.class, BigDecimal.class});

    public static String getFieldValue(Object target, String fieldName) {
        Field[] parentFields;
        Field[] fields;
        if (Objects.isNull(target)) {
            return null;
        }
        Class<?> targetClass = target.getClass();
        for (Field field : fields = targetClass.getDeclaredFields()) {
            String result = FieldUtils.getFieldValue(fieldName, field, target);
            if (!Objects.nonNull(result)) continue;
            return result;
        }
        Class<?> parentClass = targetClass.getSuperclass();
        if (parentClass.equals(Object.class)) {
            return null;
        }
        for (Field field : parentFields = parentClass.getDeclaredFields()) {
            String result = FieldUtils.getFieldValue(fieldName, field, target);
            if (!Objects.nonNull(result)) continue;
            return result;
        }
        return null;
    }

    private static String getFieldValue(String fieldName, Field field, Object target) {
        if (Objects.isNull(target)) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        String name = field.getName();
        Class<?> type = field.getType();
        try {
            Object targetObj;
            String value;
            if (FieldUtils.nameEqual(name, fieldName) && String.class.equals(type)) {
                return (String)field.get(target);
            }
            if (!basicClass.contains(type) && Objects.nonNull(value = FieldUtils.getFieldValue(targetObj = field.get(target), fieldName))) {
                return value;
            }
        }
        catch (IllegalAccessException e) {
            logger.error("\u83b7\u53d6\u503c\u9519\u8bef", e);
        }
        return null;
    }

    public static <T> void mergeField(T targetObj, T mergeObj) {
        Field[] fields;
        if (targetObj == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u76ee\u6807\u5bf9\u8c61\u4e3a\u7a7a", (String)"FieldUtils_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        if (mergeObj == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5408\u5e76\u5bf9\u8c61\u4e3a\u7a7a", (String)"FieldUtils_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        Class<?> clazz = targetObj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                ReflectionUtils.makeAccessible((Field)field);
                Object value = field.get(targetObj);
                if (Objects.isNull(value)) {
                    value = field.get(mergeObj);
                }
                field.set(targetObj, value);
            }
            catch (IllegalAccessException e) {
                logger.error("\u590d\u5236\u5931\u8d25", e);
            }
        }
    }

    public static <O, T> void fieldsCopy(O origin, T target, boolean strict) {
        Preconditions.checkNotNull(origin, (Object)ResManager.loadKDString((String)"\u590d\u5236\u539f\u59cb\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FieldUtils_2", (String)"ebg-egf-common", (Object[])new Object[0]));
        Preconditions.checkNotNull(target, (Object)ResManager.loadKDString((String)"\u590d\u5236\u76ee\u6807\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FieldUtils_3", (String)"ebg-egf-common", (Object[])new Object[0]));
        Class<?> oClass = origin.getClass();
        Class<?> tClass = target.getClass();
        Field[] oFields = oClass.getDeclaredFields();
        Field[] tFields = tClass.getDeclaredFields();
        for (Field oField : oFields) {
            for (Field tField : tFields) {
                String oFieldName = oField.getName();
                String tFieldName = tField.getName();
                if (strict) {
                    if (!FieldUtils.nameDeepEquals(oFieldName, tFieldName)) continue;
                    FieldUtils.fieldCopy(origin, target, oField, tField);
                    continue;
                }
                if (!FieldUtils.nameEqual(oFieldName, tFieldName)) continue;
                FieldUtils.fieldCopy(origin, target, oField, tField);
            }
        }
    }

    public static <O, T> void fieldsCopy(O origin, T target) {
        FieldUtils.fieldsCopy(origin, target, false);
    }

    private static boolean matchType(Field fieldO, Field fieldT, Class<?> type1) {
        return fieldO.getType().equals(type1) && fieldT.getType().equals(type1);
    }

    private static boolean matchType(Field fieldO, Field fieldT, Class<?> type1, Class<?> type2) {
        return !(!fieldO.getType().equals(type1) && !fieldO.getType().equals(type2) || !fieldT.getType().equals(type1) && !fieldT.getType().equals(type2));
    }

    private static boolean matchType(Field fieldO, Class<?> type1) {
        return fieldO.getType().equals(type1);
    }

    private static boolean matchType(Field fieldO, Class<?> type1, Class<?> type2) {
        return fieldO.getType().equals(type1) || fieldO.getType().equals(type2);
    }

    private static void copyBaseType(Object origin, Object target, Field fieldO, Field fieldT) {
        ReflectionUtils.makeAccessible((Field)fieldO);
        ReflectionUtils.makeAccessible((Field)fieldT);
        try {
            Object originValue = fieldO.get(origin);
            fieldT.set(target, originValue);
        }
        catch (IllegalAccessException e) {
            logger.error("\u540c\u540d\u5b57\u6bb5\u8d4b\u503c\u5f02\u5e38", e);
        }
    }

    private static BigDecimal string2Decimal(String str) {
        if (StrUtil.isNotBlank(str)) {
            return new BigDecimal(str);
        }
        return null;
    }

    private static LocalDate string2LocalDate(String str) {
        if (StrUtil.isNotBlank(str)) {
            return LocalDate.parse(str, DateTimeFormatter.BASIC_ISO_DATE);
        }
        return null;
    }

    private static LocalTime string2LocalTime(String str) {
        if (StrUtil.isNotBlank(str)) {
            return LocalTime.parse(str, timeFormatter);
        }
        return null;
    }

    private static LocalDateTime string2LocalDateTime(String str) {
        LocalDateTime dateTime = null;
        if (!StrUtil.isBlank(str) && NumberUtil.isNumber(str)) {
            if (str.length() == 13) {
                long timestamp = Long.parseLong(str);
                dateTime = LocalDateTime.ofEpochSecond(timestamp / 1000L, (int)(timestamp % 1000L) * 1000 * 1000, ZoneOffset.ofHours(8));
            } else if (str.length() == 8) {
                dateTime = LocalDateTime.parse(str + "000000", dateTimeFormatter);
            } else if (str.length() == 14) {
                dateTime = LocalDateTime.parse(str, dateTimeFormatter);
            } else {
                throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a%s\u3002", (String)"FieldUtils_4", (String)"ebg-egf-common", (Object[])new Object[0]), str));
            }
        }
        return dateTime;
    }

    private static String decimal2String(BigDecimal decimal) {
        if (Objects.nonNull(decimal)) {
            return decimal.toString();
        }
        return null;
    }

    private static String localDate2String(LocalDate localDate) {
        if (Objects.nonNull(localDate)) {
            return localDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        }
        return null;
    }

    private static String localTime2String(LocalTime localTime) {
        if (Objects.nonNull(localTime)) {
            return localTime.format(timeFormatter);
        }
        return null;
    }

    private static String localDateTime2String(LocalDateTime localDateTime) {
        if (Objects.nonNull(localDateTime)) {
            return localDateTime.format(dateTimeFormatter);
        }
        return null;
    }

    private static <T> void copyRefTyte(Object origin, Object target, Field fieldO, Field fieldT, Class<T> expectedType) {
        ReflectionUtils.makeAccessible((Field)fieldO);
        ReflectionUtils.makeAccessible((Field)fieldT);
        try {
            Object originValue = fieldO.get(origin);
            String jsonStr = JsonUtil.toJson(originValue);
            fieldT.set(target, JsonUtil.json2Obj(jsonStr, expectedType));
        }
        catch (Exception e) {
            logger.error("\u540c\u540d\u5b57\u6bb5\u8d4b\u503c\u5f02\u5e38", e);
        }
    }

    private static boolean nameDeepEquals(String name1, String name2) {
        return name1.equalsIgnoreCase(name2);
    }

    private static boolean nameEqual(String name1, String name2) {
        String name1Copy = StringUtils.replace(name1, SEPARATOR, "");
        String name2Copy = StringUtils.replace(name2, SEPARATOR, "");
        return name1Copy.equalsIgnoreCase(name2Copy);
    }

    private static <O, T> void fieldCopy(O origin, T target, Field fieldO, Field fieldT) {
        if (Objects.isNull(origin) || Objects.isNull(target) || Objects.isNull(fieldO) || Objects.isNull(fieldT)) {
            logger.info("\u4e0d\u540c\u7c7b\u578b\u540c\u540d\u5b57\u6bb5\u590d\u5236\uff0c\u5bf9\u8c61\u548c\u5b57\u6bb5\u90fd\u4e0d\u5141\u8bb8\u4e3a\u7a7a  [origin, target, fieldO, fieldT] is null? [{}, {}, {}, {}]", Objects.isNull(origin), Objects.isNull(target), Objects.isNull(fieldO), Objects.isNull(fieldT));
            return;
        }
        Class<?> oType = fieldO.getType();
        Class<?> tType = fieldT.getType();
        if (FieldUtils.matchType(fieldO, fieldT, Boolean.TYPE, Boolean.class)) {
            FieldUtils.copyBaseType(origin, target, fieldO, fieldT);
        } else if (FieldUtils.matchType(fieldO, fieldT, Byte.TYPE, Byte.class)) {
            FieldUtils.copyBaseType(origin, target, fieldO, fieldT);
        } else if (FieldUtils.matchType(fieldO, fieldT, Short.TYPE, Short.class)) {
            FieldUtils.copyBaseType(origin, target, fieldO, fieldT);
        } else if (FieldUtils.matchType(fieldO, fieldT, Integer.TYPE, Integer.class)) {
            FieldUtils.copyBaseType(origin, target, fieldO, fieldT);
        } else if (FieldUtils.matchType(fieldO, fieldT, Float.TYPE, Float.class)) {
            FieldUtils.copyBaseType(origin, target, fieldO, fieldT);
        } else if (FieldUtils.matchType(fieldO, fieldT, Double.TYPE, Double.class)) {
            FieldUtils.copyBaseType(origin, target, fieldO, fieldT);
        } else if (FieldUtils.matchType(fieldO, fieldT, Long.TYPE, Long.class)) {
            FieldUtils.copyBaseType(origin, target, fieldO, fieldT);
        } else if (FieldUtils.matchType(fieldO, fieldT, String.class)) {
            FieldUtils.copyRefTyte(origin, target, fieldO, fieldT, String.class);
        } else if (FieldUtils.matchType(fieldO, fieldT, Date.class)) {
            FieldUtils.copyRefTyte(origin, target, fieldO, fieldT, Date.class);
        } else if (FieldUtils.matchType(fieldO, fieldT, LocalDate.class)) {
            FieldUtils.copyRefTyte(origin, target, fieldO, fieldT, LocalDate.class);
        } else if (FieldUtils.matchType(fieldO, fieldT, LocalTime.class)) {
            FieldUtils.copyRefTyte(origin, target, fieldO, fieldT, LocalTime.class);
        } else if (FieldUtils.matchType(fieldO, fieldT, LocalDateTime.class)) {
            FieldUtils.copyRefTyte(origin, target, fieldO, fieldT, LocalDateTime.class);
        } else if (FieldUtils.matchType(fieldO, fieldT, BigDecimal.class)) {
            FieldUtils.copyRefTyte(origin, target, fieldO, fieldT, BigDecimal.class);
        } else if (oType.equals(String.class) && supportConvertType.contains(tType)) {
            FieldUtils.string2Support(origin, target, fieldO, fieldT, tType);
        } else if (tType.equals(String.class) && supportConvertType.contains(oType)) {
            FieldUtils.support2String(origin, target, fieldO, fieldT, oType);
        }
    }

    private static void support2String(Object origin, Object target, Field fieldO, Field fieldT, Class<?> oType) {
        ReflectionUtils.makeAccessible((Field)fieldO);
        ReflectionUtils.makeAccessible((Field)fieldT);
        try {
            Object originValue = fieldO.get(origin);
            String value = null;
            if (LocalDate.class.equals(oType)) {
                LocalDate date = (LocalDate)originValue;
                value = FieldUtils.localDate2String(date);
            } else if (LocalTime.class.equals(oType)) {
                LocalTime time = (LocalTime)originValue;
                value = FieldUtils.localTime2String(time);
            } else if (LocalDateTime.class.equals(oType)) {
                LocalDateTime dateTime = (LocalDateTime)originValue;
                value = FieldUtils.localDateTime2String(dateTime);
            } else if (BigDecimal.class.equals(oType)) {
                BigDecimal decimal = (BigDecimal)originValue;
                value = FieldUtils.decimal2String(decimal);
            }
            fieldT.set(target, value);
        }
        catch (Exception e) {
            logger.error("\u540c\u540d\u5b57\u6bb5\u8d4b\u503c\u5f02\u5e38", e);
        }
    }

    private static void string2Support(Object origin, Object target, Field fieldO, Field fieldT, Class<?> tType) {
        ReflectionUtils.makeAccessible((Field)fieldO);
        ReflectionUtils.makeAccessible((Field)fieldT);
        try {
            Object originValue = fieldO.get(origin);
            String str = (String)originValue;
            Comparable<ChronoLocalDate> value = null;
            if (LocalDate.class.equals(tType)) {
                value = FieldUtils.string2LocalDate(str);
            } else if (LocalTime.class.equals(tType)) {
                value = FieldUtils.string2LocalTime(str);
            } else if (LocalDateTime.class.equals(tType)) {
                value = FieldUtils.string2LocalDateTime(str);
            } else if (BigDecimal.class.equals(tType)) {
                value = FieldUtils.string2Decimal(str);
            }
            fieldT.set(target, value);
        }
        catch (Exception e) {
            logger.error("\u540c\u540d\u5b57\u6bb5\u8d4b\u503c\u5f02\u5e38", e);
        }
    }

    public static void copyFields(Object source, Object target, List<String> skipFieldNames) {
        HashSet<String> skips = new HashSet<String>();
        if (skipFieldNames != null) {
            skips.addAll(skipFieldNames);
        }
        HashMap<String, Field> sourceFieldMap = FieldUtils.getAllFields(source);
        HashMap<String, Field> targetFieldMap = FieldUtils.getAllFields(target);
        sourceFieldMap.forEach((key, value) -> {
            ReflectionUtils.makeAccessible((Field)value);
            try {
                if (value.get(source) != null && !skips.contains(key) && targetFieldMap.containsKey(key)) {
                    ReflectionUtils.makeAccessible((Field)((Field)targetFieldMap.get(key)));
                    ((Field)targetFieldMap.get(key)).set(target, value.get(source));
                }
            }
            catch (IllegalAccessException e) {
                EBExceiptionUtil.serviceException(e);
            }
        });
    }

    private static HashMap<String, Field> getAllFields(Object obj) {
        ArrayList<Field> fields = new ArrayList<Field>(1);
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        HashMap<String, Field> fieldMap = new HashMap<String, Field>(16);
        for (Field field : fields) {
            fieldMap.putIfAbsent(field.getName(), field);
        }
        return fieldMap;
    }
}

