/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.plugin.codeless;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.egf.formplugin.plugin.common.NoteCodeLessCommonFormPlugin;
import kd.ebg.egf.formplugin.plugin.util.DataToJsonFormatUtils;
import kd.ebg.egf.formplugin.plugin.util.DataToXmlFormatUtils;
import kd.ebg.egf.formplugin.plugin.util.EBGParamUtils;
import kd.ebg.egf.formplugin.plugin.util.JsonModel;
import kd.ebg.egf.formplugin.plugin.util.JsonUtil;
import kd.ebg.egf.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.egf.formplugin.service.model.EbgParam;
import org.jdom2.Element;

public class CodeLessFormPlugin
extends NoteCodeLessCommonFormPlugin
implements CellClickListener,
BeforeF7SelectListener {
    public void afterCopyData(EventObject e) {
        this.setNewNumber();
    }

    public void afterCreateNewData(EventObject e) {
        this.setBankVersion();
        this.setNewNumber();
    }

    private void setBankVersion() {
        String isFromOldPage = this.getView().getPageCache().get("isFromOldPage");
        if (StringUtils.isNotEmpty((String)isFromOldPage)) {
            String groupID = this.getView().getPageCache().get("groupID");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"note_bank_app_list", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{Long.valueOf(groupID)})});
            if (dynamicObject != null) {
                this.getModel().setValue("group", (Object)dynamicObject);
            }
        }
    }

    private void setNewNumber() {
        if (StringUtils.isEmpty((String)((String)this.getModel().getValue("number")))) {
            String bankVersionID = this.getBankVersionID();
            String number = "EBGCODELESS-" + bankVersionID + "-" + Sequence.gen14Sequence().toUpperCase();
            this.getModel().setValue("number", (Object)number);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.changeRspEbgParam(this.getBizType());
        this.changeRspMatch(this.getBizType());
        this.hideWZReuqestBody();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("bodyentryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl("bodyfileentryentity");
        entryGrid2.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid3 = (EntryGrid)this.getControl("bodyfilenameentity");
        entryGrid3.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid4 = (EntryGrid)this.getControl("bodyfilecontentity");
        entryGrid4.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid6 = (EntryGrid)this.getControl("rspcode_outentity");
        entryGrid6.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid7 = (EntryGrid)this.getControl("rspcode_innerentity");
        entryGrid7.addCellClickListener((CellClickListener)this);
        BasedataEdit parse_conditions = (BasedataEdit)this.getView().getControl("parse_judging_conditions");
        parse_conditions.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("judging_conditions");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit3 = (BasedataEdit)this.getView().getControl("judging_conditions3");
        basedataEdit3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit2 = (BasedataEdit)this.getView().getControl("judging_conditions2");
        basedataEdit2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit rsp_out_judgings = (BasedataEdit)this.getView().getControl("rsp_out_judgings");
        rsp_out_judgings.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit rsp_inner_judgings = (BasedataEdit)this.getView().getControl("rsp_inner_judgings");
        rsp_inner_judgings.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit biztype = (BasedataEdit)this.getView().getControl("biz_type_new");
        biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"judging_conditions") || StringUtils.equals((String)fieldKey, (String)"judging_conditions3") || StringUtils.equals((String)fieldKey, (String)"judging_conditions2") || StringUtils.equals((String)fieldKey, (String)"parse_judging_conditions")) {
            String bizType = this.getBizType();
            if (StringUtils.isEmpty((String)bizType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"CodeLessFormPlugin_0", (String)"ebg-egf-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (StringUtils.equals((String)fieldKey, (String)"parse_judging_conditions")) {
                this.setJudgingConditionsFilters(e, bizType, "parse");
            } else {
                this.setJudgingConditionsFilters(e, bizType);
            }
        } else if (StringUtils.equals((String)fieldKey, (String)"rsp_out_judgings")) {
            this.setCodeJudgingConditionsFilters(e, "out_stat");
        } else if (StringUtils.equals((String)fieldKey, (String)"rsp_inner_judgings")) {
            this.setCodeJudgingConditionsFilters(e, "inner_stat");
        } else if (StringUtils.equals((String)fieldKey, (String)"biz_type_new")) {
            String longnumber = this.getModel().getDataEntity().getString("group.longnumber");
            String type = "";
            if (longnumber.endsWith("NOTE")) {
                type = "NOTE";
            } else if (longnumber.endsWith("CREDIT")) {
                type = "CREDIT";
            } else if (longnumber.endsWith("PAY")) {
                type = "PAY";
            } else if (longnumber.endsWith("DETAIL")) {
                type = "DETAIL";
            } else if (longnumber.endsWith("BALANCE")) {
                type = "BALANCE";
            } else if (longnumber.endsWith("QUERY")) {
                type = "QUERY";
            }
            if (StringUtils.isNotEmpty((String)type)) {
                QFilter qFilter = new QFilter("biz_type", "=", (Object)type);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    private void setJudgingConditionsFilters(BeforeF7SelectEvent e, String bizType) {
        QFilter qFilter = QFilter.of((String)"biz_type_new.number=? and group.id=? and judge_type!=?", (Object[])new Object[]{bizType, this.getModel().getDataEntity().getLong("group.id"), "parse"});
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void setJudgingConditionsFilters(BeforeF7SelectEvent e, String bizType, String judgeType) {
        QFilter qFilter = QFilter.of((String)"biz_type_new.number=? and group.id=? and judge_type=?", (Object[])new Object[]{bizType, this.getModel().getDataEntity().getLong("group.id"), judgeType});
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void setCodeJudgingConditionsFilters(BeforeF7SelectEvent e, String type) {
        QFilter qFilter = QFilter.of((String)"group.id=? and type = ?", (Object[])new Object[]{this.getModel().getDataEntity().getLong("group.id"), type});
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)"trans_code", (String)fieldKey)) {
            this.setNewNumber();
        } else if (StringUtils.equals((String)"biz_type_new", (String)fieldKey)) {
            String bizType = this.getBizType();
            this.changeRspEbgParam(bizType);
            this.changeRspMatch(bizType);
            this.setNewNumber();
            this.hideWZReuqestBody();
            this.clearDataAfterTypeChanged();
        } else if (StringUtils.equals((String)"file_head_tag", (String)fieldKey)) {
            String tagValue = (String)this.getModel().getValue("file_head_tag");
            if (tagValue.length() > 255) {
                tagValue = tagValue.substring(0, 255);
            }
            this.getModel().setValue("file_head", (Object)tagValue);
        } else if (StringUtils.equals((String)"file_head", (String)fieldKey)) {
            this.getModel().setValue("file_head_tag", this.getModel().getValue("file_head"));
        }
    }

    public void changeRspEbgParam(String bizType) {
        List<EbgParam> params = EBGParamUtils.getNoteRspMetaParamByBizType(bizType);
        ComboEdit comboEdit = (ComboEdit)this.getControl("rsp_ebgparam");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
        if (params != null && params.size() > 0) {
            for (EbgParam param : params) {
                data.add(new ComboItem(new LocaleString(param.getName()), param.getKey()));
            }
        }
        comboEdit.setComboItems(data);
    }

    public void clearDataAfterTypeChanged() {
        DynamicObjectCollection dataEntity = this.getModel().getEntryEntity("bodyentryentity");
        for (Object row : dataEntity) {
            row.set("ebg_field", (Object)"");
            row.set("judging_conditions", null);
        }
        DynamicObjectCollection bodyfilenameentity = this.getModel().getEntryEntity("bodyfilenameentity");
        for (Object row : bodyfilenameentity) {
            row.set("ebg_field3", (Object)"");
            row.set("judging_conditions3", null);
        }
        DynamicObjectCollection bodyfilecontentity = this.getModel().getEntryEntity("bodyfilecontentity");
        for (DynamicObject row : bodyfilecontentity) {
            row.set("ebg_field2", (Object)"");
            row.set("judging_conditions2", null);
        }
        DynamicObjectCollection rspbody_entryentity = this.getModel().getEntryEntity("rspbody_entryentity");
        for (DynamicObject row : rspbody_entryentity) {
            row.set("rsp_ebgparam", (Object)"");
            row.set("rsp_match", (Object)"");
            row.set("parse_judging_conditions", null);
        }
        this.getView().updateView("bodyentryentity");
        this.getView().updateView("bodyfilenameentity");
        this.getView().updateView("bodyfilecontentity");
        this.getView().updateView("rspbody_entryentity");
    }

    public void changeRspMatch(String bizType) {
        List<EbgParam> params = EBGParamUtils.getNoteReqMetaParamByBizType(bizType);
        ComboEdit comboEdit = (ComboEdit)this.getControl("rsp_match");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
        if (params != null && params.size() > 0) {
            for (EbgParam param : params) {
                data.add(new ComboItem(new LocaleString(param.getName()), param.getKey()));
            }
        }
        comboEdit.setComboItems(data);
    }

    public String getBankVersionID() {
        return this.getModel().getDataEntity().getString("group.longnumber").split("\\.")[0];
    }

    public String getBizType() {
        return this.getModel().getDataEntity().getString("biz_type_new.number");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        DynamicObjectCollection nextPage_entity;
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        if ("bodypreview".equals(operateKey)) {
            this.showDataPreview("bodyentryentity", "paramnode", "paramname", "example");
        } else if ("rspbody_preview".equals(operateKey)) {
            this.showDataPreview("rspbody_entryentity", "rsp_paramnode", "rsp_paramname", "");
        } else if ("import_request".equals(operateKey)) {
            DynamicObjectCollection requests = this.getModel().getEntryEntity("bodyentryentity");
            if (requests != null && requests.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bf7\u6c42\u5355\u636e\u4f53\u5df2\u5b58\u5728\u8bb0\u5f55\uff0c\u8bf7\u5220\u9664\u540e\u518d\u5bfc\u5165\u3002", (String)"CodeLessFormPlugin_1", (String)"ebg-egf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showImportPage("request", this.getContentType());
        } else if ("import_response".equals(operateKey)) {
            DynamicObjectCollection responses = this.getModel().getEntryEntity("rspbody_entryentity");
            if (responses != null && responses.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u54cd\u5e94\u5355\u636e\u4f53\u5df2\u5b58\u5728\u8bb0\u5f55\uff0c\u8bf7\u5220\u9664\u540e\u518d\u5bfc\u5165\u3002", (String)"CodeLessFormPlugin_2", (String)"ebg-egf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showImportPage("response", this.getContentType());
        } else if ("new".equals(operateKey) || "save".equals(operateKey)) {
            this.newDataSetPageCache();
        } else if ("add_nextpage".equals(operateKey)) {
            DynamicObjectCollection nextPage_entity2 = this.getModel().getEntryEntity("nextpage_entity");
            if (nextPage_entity2.size() == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"add_nextpage"});
            }
        } else if ("delete_nextpage".equals(operateKey) && (nextPage_entity = this.getModel().getEntryEntity("nextpage_entity")).size() == 1) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"add_nextpage"});
        }
    }

    private String getContentType() {
        String type = (String)this.getModel().getValue("contenttype");
        if ("cdata_xml".equals(type)) {
            type = "xml";
        }
        return type;
    }

    private void newDataSetPageCache() {
        this.getView().getPageCache().put("isFromOldPage", "true");
        String groupID = this.getModel().getDataEntity().getString("group.id");
        this.getView().getPageCache().put("groupID", groupID);
    }

    private void showDataPreview(String entityKey, String typeKey, String nameKey, String valueKey) {
        DynamicObjectCollection responses = this.getModel().getEntryEntity(entityKey);
        if (CollectionUtils.isEmpty((Collection)responses)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u3002", (String)"CodeLessFormPlugin_3", (String)"ebg-egf-formplugin", (Object[])new Object[0]));
            return;
        }
        String contentType = (String)this.getModel().getValue("contenttype");
        if (StringUtils.isEmpty((String)contentType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u683c\u5f0f\u3002", (String)"CodeLessFormPlugin_4", (String)"ebg-egf-formplugin", (Object[])new Object[0]));
            return;
        }
        String data = "";
        data = "xml".equals(this.getContentType()) ? DataToXmlFormatUtils.objectToXml(DataToJsonFormatUtils.getFormatDataMap(responses, typeKey, nameKey, valueKey), contentType) : JsonUtil.fromJson(JSON.toJSON(DataToJsonFormatUtils.getFormatDataMap(responses, typeKey, nameKey, valueKey)).toString());
        this.showDataPreview(data);
    }

    private void showDataPreview(String previewData) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("note_param_priview");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("previewData", (Object)previewData);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showImportPage(String resource, String type) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("source", resource);
        customParams.put("type", type);
        String entityKey = "note_import_param";
        if ("json".equals(type)) {
            entityKey = "note_param_json";
        }
        ShowPageUtil.showFormPage(entityKey, customParams, OperationStatus.ADDNEW, this.getView(), (IFormPlugin)this);
    }

    public void cellClick(CellClickEvent evt) {
        if ("ebg_field".equals(evt.getFieldKey())) {
            if ("ebg_field".equals(this.getModel().getValue("ebgparam_source", evt.getRow()))) {
                this.clickReqEbgField("bodyentryentity", evt.getRow(), this.getBizType(), this.getBankVersionID());
            }
        } else if ("ebg_field1".equals(evt.getFieldKey())) {
            this.clickReqEbgField("bodyfileentryentity", evt.getRow(), this.getBizType(), this.getBankVersionID());
        } else if ("ebg_field3".equals(evt.getFieldKey())) {
            if ("ebg_field".equals(this.getModel().getValue("ebgparam_source3", evt.getRow()))) {
                this.clickReqEbgField("bodyfilenameentity", evt.getRow(), this.getBizType(), this.getBankVersionID());
            }
        } else if ("ebg_field2".equals(evt.getFieldKey()) && "ebg_field".equals(this.getModel().getValue("ebgparam_source2", evt.getRow()))) {
            this.clickReqEbgField("bodyfilecontentity", evt.getRow(), this.getBizType(), this.getBankVersionID());
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        block7: {
            super.closedCallBack(closedCallBackEvent);
            if (closedCallBackEvent.getReturnData() == null) break block7;
            if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection selectCollections = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                String rowStr = closedCallBackEvent.getActionId();
                int row = Integer.parseInt(rowStr);
                for (ListSelectedRow selectedRow : selectCollections) {
                    this.closedCallBackByEbgField(selectedRow, row);
                }
            } else {
                try {
                    String result = (String)closedCallBackEvent.getReturnData();
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    String paramStr = jsonObject.getString("paramStr");
                    String source = jsonObject.getString("source");
                    String type = jsonObject.getString("type");
                    if ("xml".equals(type)) {
                        Element element = JDomUtils.string2Root((String)paramStr, (String)"gb2312");
                        this.transMapToBodyRows(element, 0L, "request".equals(source));
                    }
                    JSONObject object = JSONObject.parseObject((String)paramStr);
                    this.transMapToBodyRows(object, 0L, "request".equals(source));
                }
                catch (OpenApiException var4) {
                    this.getView().showErrorNotification(var4.getMessage());
                }
                catch (Exception var5) {
                    this.getView().showMessage(var5.getMessage());
                }
            }
        }
    }

    private void transMapToBodyRows(Element element, long pid, boolean isRequest) {
        String entityKey = isRequest ? "bodyentryentity" : "rspbody_entryentity";
        DynamicObjectType type = this.getModel().getEntryEntity(entityKey).getDynamicObjectType();
        List list = element.getChildren();
        boolean isExitsChild = list.size() > 0;
        DynamicObject row = this.createRow(element, type, pid, isExitsChild, isRequest);
        if (isExitsChild) {
            pid = (Long)row.getPkValue();
            for (Element element1 : list) {
                this.transMapToBodyRows(element1, pid, isRequest);
            }
        }
    }

    private void transMapToBodyRows(JSONObject jsonObject, long pid, boolean isRequest) {
        String entityKey = isRequest ? "bodyentryentity" : "rspbody_entryentity";
        DynamicObjectType type = this.getModel().getEntryEntity(entityKey).getDynamicObjectType();
        Set keys = jsonObject.keySet();
        for (String key : keys) {
            DynamicObject row;
            Object object = jsonObject.get((Object)key);
            if (object instanceof JSONObject) {
                row = this.createRow(new JsonModel(key, ""), type, pid, true, isRequest);
                this.transMapToBodyRows((JSONObject)object, (long)((Long)row.getPkValue()), isRequest);
                continue;
            }
            if (object instanceof JSONArray) {
                row = this.createRow(new JsonModel(key, ""), type, pid, true, isRequest);
                this.transMapToBodyRows(((JSONArray)object).getJSONObject(0), (long)((Long)row.getPkValue()), isRequest);
                continue;
            }
            this.createRow(new JsonModel(key, object), type, pid, false, isRequest);
        }
    }

    private DynamicObject createRow(Object element, DynamicObjectType type, Long pid, boolean isExitsChild, boolean isRequest) {
        Object value;
        Object element1;
        String paramNodeKey;
        String entityKey;
        String paramDesKey;
        String paramNameKey;
        DynamicObject row = new DynamicObject(type);
        if (pid > 0L) {
            row.set("pid", (Object)pid);
        }
        if (isRequest) {
            paramNameKey = "paramname";
            paramDesKey = "paramdes";
            entityKey = "bodyentryentity";
            paramNodeKey = "paramnode";
        } else {
            paramNameKey = "rsp_paramname";
            paramDesKey = "rsp_paramdes";
            entityKey = "rspbody_entryentity";
            paramNodeKey = "rsp_paramnode";
        }
        if (element instanceof Element) {
            element1 = (Element)element;
            row.set(paramNameKey, (Object)element1.getName());
            row.set(paramDesKey, (Object)element1.getName());
            value = element1.getTextTrim();
        } else {
            element1 = (JsonModel)element;
            row.set(paramNameKey, (Object)((JsonModel)element1).getKey());
            row.set(paramDesKey, (Object)((JsonModel)element1).getKey());
            value = ((JsonModel)element1).getValue();
        }
        if (isRequest && value != null) {
            row.set("example", value);
        }
        int rowIndex = this.getModel().createNewEntryRow(entityKey, row);
        if (isExitsChild) {
            this.getModel().setValue(paramNodeKey, (Object)"structure_node", rowIndex);
        }
        return row;
    }

    public void hideWZReuqestBody() {
        String bizType = this.getBizType();
        if ("queryBalance".equals(bizType) || "queryDetail".equals(bizType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"requestparam"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"requestparam"});
        }
    }
}

