/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.ParserUtil;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.codeless.PackerUtil.CodeLessUtil;
import kd.ebg.egf.common.codeless.PackerUtil.ResponseCode;
import kd.ebg.egf.common.codeless.ParserUtil.ParseUtil;
import kd.ebg.egf.common.codeless.ParserUtil.ParserToMapUtil;
import kd.ebg.egf.common.codeless.ParserUtil.XMLParseUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoBody;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoDetail;

public class ParserInfoUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParserInfoUtil.class);

    public static BankNoteInfoBody parseInfo(BankNoteInfoBody noteInfoBody, String rspStr) throws Exception {
        logger.info("\u4f4e\u4ee3\u7801\u6846\u67b6\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u89e3\u6790\uff1a");
        ResponseCode responseCode = CodeLessUtil.getResponseCodeNode((String)rspStr);
        logger.info("\u4f4e\u4ee3\u7801\u6846\u67b6\u4ea4\u4e92\u54cd\u5e94\u7801\u89e3\u6790\u5b8c\u6bd5\uff0c" + responseCode.getCode() + "," + responseCode.getMsg());
        String outResult = ParseUtil.getResult((ResponseCode)responseCode, null, null, (String)"NOTE");
        if (StringUtils.isEmpty((String)outResult)) {
            logger.info("\u5916\u5c42\u54cd\u5e94\u5904\u7406\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7f6e\u4e3a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5");
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u4e92\u54cd\u5e94\u7801\u5f02\u5e38%1$s %2$s %3$s\u3002", (String)"ParserInfoUtil_3", (String)"ebg-note-business", (Object[])new Object[0]), responseCode.getCode(), responseCode.getMsg(), outResult));
        }
        if ("MIDDLE".equals(outResult)) {
            return ParserInfoUtil.getInnerResult(noteInfoBody, rspStr);
        }
        logger.info("\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a" + outResult);
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7968\u636e\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s\u3002", (String)"ParserInfoUtil_4", (String)"ebg-note-business", (Object[])new Object[0]), outResult + responseCode.getCode() + "," + responseCode.getMsg()));
    }

    public static BankNoteInfoBody getInnerResult(BankNoteInfoBody noteInfoBody, String rspStr) {
        List<NoteInfoDetail> list = noteInfoBody.getDetails();
        if (list.size() != 1) {
            return ParserInfoUtil.dealBatch(noteInfoBody, rspStr);
        }
        NoteInfoDetail detail = list.get(0);
        Map needParam = CodeLessUtil.getNeedParamPath();
        Set set2 = needParam.keySet();
        set2.stream().forEach(key -> {
            if ("discountAmount".equals(key)) {
                String value = XMLParseUtil.getXmlAttrValue((String)rspStr, (String)((String)needParam.get("discountAmount")));
                detail.setDiscountAmount(value);
            } else if ("intDaysAdjust".equals(key)) {
                String value = XMLParseUtil.getXmlAttrValue((String)rspStr, (String)((String)needParam.get("intDaysAdjust")));
                detail.setIntDaysAdjust(value);
            } else if ("intDays".equals(key)) {
                String value = XMLParseUtil.getXmlAttrValue((String)rspStr, (String)((String)needParam.get("intDays")));
                detail.setIntDays(value);
            } else if ("recInt".equals(key)) {
                String value = XMLParseUtil.getXmlAttrValue((String)rspStr, (String)((String)needParam.get("recInt")));
                detail.setRecInt(value);
            }
        });
        return noteInfoBody;
    }

    private static BankNoteInfoBody dealBatch(BankNoteInfoBody noteInfoBody, String rspStr) {
        List eachData = ParseUtil.getRepeaterData((String)rspStr);
        Map map = CodeLessUtil.getNeedParam();
        Map mapMatch = CodeLessUtil.getMatchParam();
        List<NoteInfoDetail> details = noteInfoBody.getDetails();
        for (NoteInfoDetail detail : details) {
            Field[] fields = detail.getClass().getDeclaredFields();
            Map result = ParserToMapUtil.getCommonMap((Field[])fields, (String)"yyyyMMdd", (Object)detail);
            for (Map each : eachData) {
                if (!ParseUtil.judgeMatch((Map)mapMatch, (Map)each, (Map)result)) continue;
                ParserInfoUtil.reloadData(detail, each, map);
            }
        }
        return noteInfoBody;
    }

    private static void reloadData(NoteInfoDetail detail, Map eachData, Map reflect) {
        Set set2 = reflect.keySet();
        set2.stream().forEach(key -> {
            if ("discountAmount".equals(key)) {
                String value = (String)eachData.get(reflect.get("discountAmount"));
                detail.setDiscountAmount(value);
            } else if ("intDaysAdjust".equals(key)) {
                String value = (String)eachData.get(reflect.get("intDaysAdjust"));
                detail.setIntDaysAdjust(value);
            } else if ("intDays".equals(key)) {
                String value = (String)eachData.get(reflect.get("intDays"));
                detail.setIntDays(value);
            } else if ("recInt".equals(key)) {
                String value = (String)eachData.get(reflect.get("recInt"));
                detail.setRecInt(value);
            }
        });
    }
}

