/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.cache;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;

public class CachePayableStorage {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CachePayableStorage.class);
    private static final String ebPrefix = "eb_note_";
    private static final String CHECKED = "checked";
    private static final String NODE = "node";
    private static final String LOCK_TIME = "lockTime";

    public static String getKey(String key) {
        return ebPrefix + key;
    }

    public static boolean checkSubmitLock(String key) {
        String ebKey = CachePayableStorage.getKey(key);
        String value = CosmicCache.get((String)ebKey);
        if (StringUtils.isEmpty((String)value)) {
            CachePayableStorage.setLock(ebKey);
            logger.debug("\u5f53\u524d\u8bf7\u6c42\u83b7\u53d6\u5230\u9632\u91cd\u9501\uff1a" + ebKey);
            return false;
        }
        if (!CHECKED.equalsIgnoreCase(value)) {
            logger.debug("\u9632\u91cd\u9501\u5df2\u88ab\u5360\u7528\uff1a" + ebKey);
        } else {
            boolean isRepeat;
            boolean bl = isRepeat = !StringUtils.isEmpty((String)value) && CHECKED.equalsIgnoreCase(value);
            if (!isRepeat) {
                CosmicCache.putIfAbsentWithExpire((String)ebKey, (String)CHECKED, (int)30, (TimeUnit)TimeUnit.MINUTES);
                logger.debug("\u5f53\u524d\u8bf7\u6c42\u83b7\u53d6\u5230\u9632\u91cd\u9501\uff1a" + ebKey);
                return false;
            }
            logger.debug("\u9632\u91cd\u9501\u5df2\u88ab\u5360\u7528\uff1a" + ebKey);
        }
        return true;
    }

    private static void setLock(String ebKey) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String node = SingleNodeIDGetter.getInstance().nodeID();
        String lockTime = LocalDateUtil.formatLocalDateTime((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss");
        map.put(NODE, node);
        map.put(LOCK_TIME, lockTime);
        String jsonStr = JsonUtil.toJson(map);
        CosmicCache.putWithExpire((String)ebKey, (String)jsonStr, (int)30, (TimeUnit)TimeUnit.MINUTES);
    }

    public static boolean release(String key) {
        String ebKey = CachePayableStorage.getKey(key);
        try {
            CosmicCache.delete((String)ebKey);
            logger.debug("\u5f53\u524d\u8bf7\u6c42\u91ca\u653e\u9632\u91cd\u9501\uff1a" + ebKey);
        }
        catch (Throwable e) {
            logger.error("\u6e05\u7406\u4ed8\u6b3e\u8bf7\u6c42\u7684\u9632\u91cd\u9501\u51fa\u9519\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }
}

