/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.notePayable.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.notePayable.atomic.INotePayable;
import kd.ebg.note.business.util.CheckLengthUtil;
import kd.ebg.note.business.util.CheckUtil;
import kd.ebg.note.business.util.NoteRngNoUtils;
import kd.ebg.note.common.entity.biz.notepayable.NotePayableBody;
import kd.ebg.note.common.entity.biz.notepayable.NotePayableDetail;
import kd.ebg.note.common.entity.biz.notepayable.NotePayableRequest;
import kd.ebg.note.common.entity.biz.notepayable.NotePayableResponse;
import kd.ebg.note.common.entity.biz.querynotepayable.QueryNotePayableBody;
import kd.ebg.note.common.entity.biz.querynotepayable.QueryNotePayableDetail;
import kd.ebg.note.common.entity.biz.querynotepayable.QueryNotePayableRequest;
import kd.ebg.note.common.entity.biz.querynotepayable.QueryNotePayableResponse;
import kd.ebg.note.common.entity.biz.status.EbStatus;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.utils.CurrencyUtils;
import kd.ebg.note.common.model.NotePayableInfo;

public class NotePayableConvert {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(NotePayableConvert.class);

    public static QueryNotePayableResponse convertToResponse(List<NotePayableInfo> paymentInfos, QueryNotePayableRequest queryNotePayableRequest) {
        QueryNotePayableResponse response = new QueryNotePayableResponse();
        response.setHeader(queryNotePayableRequest.getHeader());
        QueryNotePayableBody body = NotePayableConvert.convertBody(paymentInfos);
        body.setBatchSeqId(queryNotePayableRequest.getBody().getBatchSeqId());
        response.setBody(body);
        return response;
    }

    public static NotePayableResponse convertToResponse(List<NotePayableInfo> paymentInfos, NotePayableRequest payRequest) {
        NotePayableResponse response = new NotePayableResponse();
        response.setHeader(payRequest.getHeader());
        NotePayableBody body = NotePayableConvert.convert2Body(paymentInfos);
        body.setBatchSeqId(payRequest.getBody().getBatchSeqId());
        body.setTotalAmount(payRequest.getBody().getTotalAmount());
        body.setTotalCount(payRequest.getBody().getTotalCount());
        response.setBody(body);
        return response;
    }

    public static NotePayableBody convert2Body(List<NotePayableInfo> notePayableInfos) {
        NotePayableBody body = new NotePayableBody();
        ArrayList<NotePayableDetail> details = new ArrayList<NotePayableDetail>(notePayableInfos.size());
        for (NotePayableInfo info : notePayableInfos) {
            NotePayableDetail detail = new NotePayableDetail();
            FieldUtils.fieldsCopy((Object)info, (Object)detail);
            details.add(detail);
            String subRange = detail.getSubRange();
            if (StringUtils.isNotEmpty((String)subRange) && !subRange.equals("0") && !subRange.equals("000000000000,000000000000")) {
                subRange = subRange.replaceAll("[^\\d]", ",");
                detail.setSubRange(subRange);
                if (StringUtils.isNotEmpty((String)detail.getStartNo()) && StringUtils.isNotEmpty((String)detail.getEndNo())) {
                    String startNo = detail.getStartNo();
                    String endNo = detail.getEndNo();
                    BigDecimal start = new BigDecimal(startNo);
                    BigDecimal end = new BigDecimal(endNo);
                    String[] split = subRange.split(",");
                    if (split.length == 2) {
                        BigDecimal secondRange;
                        BigDecimal sub1 = new BigDecimal(split[0]);
                        BigDecimal sub2 = new BigDecimal(split[1]);
                        BigDecimal firstRange = end.subtract(start);
                        int result = firstRange.compareTo(secondRange = sub2.subtract(sub1));
                        if (result < 0) {
                            detail.setSubRange(startNo + ',' + endNo);
                        } else if (result > 0) {
                            detail.setStartNo(split[0]);
                            detail.setEndNo(split[1]);
                        }
                    }
                }
            } else if ("0".equals(detail.getGrdBag())) {
                detail.setStartNo("0");
                detail.setEndNo("0");
                detail.setSubRange("0");
            }
            NotePayableConvert.formateNo(detail);
            detail.setBankMsg(info.bankMsgDetails());
            detail.setEbSeqID(info.getId() + "");
            detail.setEbStatus(EbStatus.convertBankState2EBG((PaymentState)PaymentState.getEnumById((int)info.getStatus())).getName());
            detail.setFlowSerialNo(info.getObssid());
            if (StringUtils.isNotEmpty((String)info.getErrorMsg())) {
                detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%1$s\uff0c\u94f6\u4f01\u5f02\u5e38\uff1a%2$s\u3002", (String)"NotePayableConvert_13", (String)"ebg-note-business", (Object[])new Object[0]), info.getStatusMsg(), info.getErrorMsg()));
                continue;
            }
            detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%s\u3002", (String)"NotePayableConvert_14", (String)"ebg-note-business", (Object[])new Object[0]), info.getStatusMsg()));
        }
        body.setDetails(details);
        return body;
    }

    public static QueryNotePayableBody convertBody(List<NotePayableInfo> notePayableInfos) {
        QueryNotePayableBody body = new QueryNotePayableBody();
        ArrayList<QueryNotePayableDetail> details = new ArrayList<QueryNotePayableDetail>(notePayableInfos.size());
        for (NotePayableInfo info : notePayableInfos) {
            QueryNotePayableDetail detail = new QueryNotePayableDetail();
            FieldUtils.fieldsCopy((Object)info, (Object)detail);
            details.add(detail);
            String subRange = detail.getSubRange();
            if (StringUtils.isNotEmpty((String)subRange)) {
                subRange = subRange.replaceAll("[^\\d]", ",");
                detail.setSubRange(subRange);
            }
            detail.setAcceptorCnapsCode(info.getAcceptorBankCnaps());
            detail.setBankMsg(info.bankMsgDetails());
            detail.setEbSeqID(info.getId() + "");
            detail.setRspSerialNo(info.getRspserialno());
            detail.setFlowSerialNo(info.getObssid());
            detail.setEbStatus(EbStatus.convertBankState2EBG((PaymentState)PaymentState.getEnumById((int)info.getStatus())).getName());
            detail.setReserveds(info.getReserved4());
            if (StringUtils.isNotEmpty((String)info.getErrorMsg())) {
                detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%1$s\uff0c\u94f6\u4f01\u5f02\u5e38\uff1a%2$s\u3002", (String)"NotePayableConvert_13", (String)"ebg-note-business", (Object[])new Object[0]), info.getStatusMsg(), info.getErrorMsg()));
                continue;
            }
            detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%s\u3002", (String)"NotePayableConvert_14", (String)"ebg-note-business", (Object[])new Object[0]), info.getStatusMsg()));
        }
        body.setDetails(details);
        body.setTotalCount(notePayableInfos.size());
        return body;
    }

    public static List<NotePayableInfo> convertPay(NotePayableRequest request) {
        NotePayableBody body = request.getBody();
        String bizType = request.getHeader().getBizType();
        String subBizType = request.getHeader().getSubBizType();
        String currency = request.getHeader().getCurrency();
        int totalCount = body.getTotalCount();
        BigDecimal totalAmount = CheckUtil.checkBigDecimal(body.getTotalAmount(), ResManager.loadKDString((String)"\u8bf7\u6c42\u91cc\u7684\u4ed8\u6b3e\u603b\u91d1\u989d\u3002", (String)"NotePayableConvert_2", (String)"ebg-note-business", (Object[])new Object[0]));
        String batchSeqID = body.getBatchSeqId();
        List payDetails = body.getDetails();
        EBContext context = EBContext.getContext();
        BankAcnt bankAcnt = context.getBankAcnt();
        long requestTimeStamp = request.getHeader().getRequestTime();
        LocalDateTime requestTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(requestTimeStamp), ZoneId.systemDefault());
        Preconditions.checkArgument((totalCount == payDetails.size() ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u4ed8\u6b3e\u5355\u603b\u6570(%1$s)\u548c\u8be5\u6279\u6b21\u6307\u793a\u7684\u603b\u7b14\u6570(%2$s)\u4e0d\u7b26\u3002", (String)"NotePayableConvert_15", (String)"ebg-note-business", (Object[])new Object[0]), payDetails.size(), totalCount));
        BigDecimal actualTotalAmount = new BigDecimal("0.00");
        HashSet detailSeqIDSet = Sets.newHashSetWithExpectedSize((int)payDetails.size());
        ArrayList<NotePayableInfo> paymentInfos = new ArrayList<NotePayableInfo>(payDetails.size());
        int bankSerialNo = 1;
        BankAcnt acnt = EBContext.getContext().getBankAcnt();
        String split4SubRange = BankBundleManager.getInstance().getBankSplit(context.getBankVersionID());
        for (NotePayableDetail detail : payDetails) {
            NotePayableInfo info = new NotePayableInfo();
            paymentInfos.add(info);
            CheckLengthUtil.checkLength(detail.getDrawerCnapsName(), "DrawerBankName", 50);
            CheckLengthUtil.checkLength(acnt.getBankAddress(), "DrawerBankAddress", 50);
            CheckLengthUtil.checkLength(detail.getAcceptorAccName(), "AcceptorAccName", 50);
            CheckLengthUtil.checkLength(detail.getAcceptorBankName(), "AcceptorBankName", 50);
            CheckLengthUtil.checkLength(detail.getAcceptorBankAddress(), "AcceptorBankAddress", 50);
            CheckLengthUtil.checkLength(detail.getPayeeAccName(), "PayeeAccName", 50);
            CheckLengthUtil.checkLength(detail.getPayeeBankAddr(), "PayeeBankAddr", 50);
            CheckLengthUtil.checkLength(detail.getPayeeBankName(), "PayeeBankName", 50);
            FieldUtils.fieldsCopy((Object)bankAcnt, (Object)info);
            FieldUtils.fieldsCopy((Object)detail, (Object)info);
            info.setBankVersionID(context.getBankVersionID());
            info.setBankLoginID(context.getBankLoginID());
            info.setAcceptorAccCity(detail.getAcceptorAccCity());
            info.setAcceptorAccProvince(detail.getAcceptorAccProvince());
            info.setAcceptorAccCountry(detail.getAcceptorAccCountry());
            info.setAcceptorAccNo(detail.getAcceptorAccNo());
            info.setAcceptorAccName(detail.getAcceptorAccName());
            info.setAcceptorBankCnaps(detail.getAcceptorBankCnaps());
            info.setAcceptorBankName(detail.getAcceptorBankName());
            info.setAcceptorBankAddress(detail.getAcceptorBankAddress());
            info.setBankSerialNo(String.valueOf(bankSerialNo++));
            info.setDrawerAccNo(acnt.getAccNo());
            info.setDrawerBankCnaps(detail.getDrawerCnapsCode());
            info.setDrawerAccName(acnt.getAccName());
            info.setDrawerAccCity(acnt.getCity());
            info.setDrawerAccCountry(acnt.getCountry());
            info.setDrawerBankAddress(acnt.getBankAddress());
            info.setDrawerBankName(detail.getDrawerCnapsName());
            info.setDrawerAccProvince(acnt.getProvince());
            info.setBatchSeqId(batchSeqID);
            info.setBizType(bizType);
            info.setSubBizType(subBizType);
            info.setTotalAmount(totalAmount);
            info.setTotalCount(Integer.valueOf(totalCount));
            info.setRspserialno(detail.getRspSerialNo());
            info.setRequestTime(requestTime);
            info.setRequestSeq(Sequence.genSequence());
            info.setInsertBatchSeq(request.getBody().getBatchSeqId());
            info.setDetailBizNo(detail.getDetailBizNo());
            info.setId(Long.valueOf(Sequence.gen16NumSequence()));
            info.setFileList(detail.getFileList());
            info.setExplanation(detail.getDesc());
            info.setReserved1(detail.getReserved1());
            info.setReserved2(detail.getReserved2());
            info.setReserved3(detail.getReserved3());
            info.setReserved4(detail.getReserveds());
            String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
            Preconditions.checkArgument((boolean)Objects.nonNull(bankCurrency), (Object)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u6807\u51c6\u5e01\u79cd\uff1a%s\u8f6c\u6362\u6210\u94f6\u884c\u5e01\u79cd\uff0c\u8bf7\u7ef4\u62a4\u6b63\u786e\u7684\u5e01\u79cd\u6620\u5c04\u3002", (String)"NotePayableConvert_16", (String)"ebg-note-business", (Object[])new Object[0]), bankAcnt.getCurrency()));
            info.setCurrency(bankCurrency);
            info.setCurrency(CurrencyUtils.convert2Bank((String)currency));
            String detailSeqID = detail.getDetailSeqID();
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detailSeqID), (Object)ResManager.loadKDString((String)"detailSeqID \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NotePayableConvert_8", (String)"ebg-note-business", (Object[])new Object[0]));
            Preconditions.checkState((!detailSeqIDSet.contains(detailSeqID) ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"deetailSeqID \u91cd\u590d : %s\u3002", (String)"NotePayableConvert_17", (String)"ebg-note-business", (Object[])new Object[0]), detailSeqID));
            detailSeqIDSet.add(detailSeqID);
            info.setDetailSeqId(detailSeqID);
            info.setCustomID(request.getHeader().getCustomId());
            info.setAmount(CheckUtil.checkBigDecimal(info.getAmount().toString(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"NotePayableConvert_10", (String)"ebg-note-business", (Object[])new Object[0])));
            info.setPayeeBankCnaps(detail.getPayeeCnapsCode());
            actualTotalAmount = actualTotalAmount.add(info.getAmount());
            info.setOperationCode(detail.getTranType());
            info.setObssid(detail.getFlowSerialNo());
            info.setContractNo(detail.getContractNo());
            if (StringUtils.isEmpty((String)info.getIsNewECDS())) {
                info.setIsNewECDS("1");
            }
            info.setGrdBag(detail.getGrdBag());
            info.setStartNo(detail.getStartNo());
            info.setEndNo(detail.getEndNo());
            info.setCirStatus(detail.getCirStatus());
            info.setBankRefDate(detail.getBankRefDate());
            info.setBankRefKey(detail.getBankRefKey());
            String subRange = detail.getSubRange();
            if (StringUtils.isNotEmpty((String)subRange)) {
                info.setSubRange(subRange.replaceAll(",", split4SubRange));
            }
            try {
                info.setIsAcceptSameBank(SameBankUtil.isSameBank(EBContext.getContext().getBankVersionID(), detail.getAcceptorBankName()));
                info.setIsPayeeSameBank(SameBankUtil.isSameBank(EBContext.getContext().getBankVersionID(), detail.getPayeeBankName()));
            }
            catch (Throwable t) {
                logger.error("samebank error", t);
            }
        }
        if (!actualTotalAmount.equals(totalAmount)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u63a5\u5165\u65b9\u4f20\u7684 \u603b\u91d1\u989d \uff1a%1$s \u4e0e\u8ba1\u7b97\u540e\u7684\u603b\u91d1\u989d\u4e0d\u7b26 \uff1a%2$s\u3002", (String)"NotePayableConvert_18", (String)"ebg-note-business", (Object[])new Object[0]), totalAmount, actualTotalAmount));
        }
        return paymentInfos;
    }

    public static boolean isSameCity(BankAcnt acnt, String incomeCity) {
        String payCity = acnt.getCity();
        if (StrUtil.isBlank((CharSequence)payCity) || StrUtil.isBlank((CharSequence)incomeCity)) {
            return false;
        }
        return payCity.equals(incomeCity) || payCity.contains(incomeCity) || incomeCity.contains(payCity);
    }

    private static void addBankSeqID(String bankVersionID, List<NotePayableInfo> infos) {
        String bankBatchSeqID = "";
        IBankBatchSeqIDCreator bankBatchSeqIDCreator = (IBankBatchSeqIDCreator)BankBundleManager.getInstance().getBatchSeqIdImplOrNull(bankVersionID);
        if (StringUtils.isEmpty((String)bankBatchSeqID)) {
            bankBatchSeqID = Objects.nonNull(bankBatchSeqIDCreator) ? bankBatchSeqIDCreator.getBankBatchSeqID() : Sequence.gen16Sequence();
            EBContext.getContext().setBizSeqID(bankBatchSeqID);
        }
        for (NotePayableInfo info : infos) {
            info.setBankBatchSeqId(bankBatchSeqID);
            info.setBankBatchCount(infos.size());
            info.setStatus(Integer.valueOf(PaymentState.PACKAGED.getId()));
            info.setStatusName(PaymentState.PACKAGED.getEnName());
            info.setStatusMsg(PaymentState.PACKAGED.getCnName());
            IBankDetailSeqIDCreator bankDetailSeqIDCreator = (IBankDetailSeqIDCreator)BankBundleManager.getInstance().getDetailSeqIdImplOrNull(bankVersionID);
            String bankDetailSeqID = Objects.nonNull(bankDetailSeqIDCreator) ? bankDetailSeqIDCreator.getBankDetailSeqID() : Sequence.genSequence();
            info.setBankDetailSeqId(bankDetailSeqID);
        }
    }

    public static Set<List<NotePayableInfo>> packagePay(List<NotePayableInfo> paymentInfos) {
        List infos;
        String bankVersionID = paymentInfos.get(0).getBankVersionID();
        HashSet<List<NotePayableInfo>> result = new HashSet<List<NotePayableInfo>>();
        HashMap maps = Maps.newHashMap();
        for (NotePayableInfo notePayableInfo : paymentInfos) {
            String implClassName = notePayableInfo.getImplClassName();
            if (maps.containsKey(implClassName)) {
                infos = (List)maps.get(implClassName);
                infos.add(notePayableInfo);
                continue;
            }
            infos = Lists.newArrayList((Object[])new NotePayableInfo[]{notePayableInfo});
            maps.put(implClassName, infos);
        }
        for (Map.Entry entry : maps.entrySet()) {
            String implClass = (String)entry.getKey();
            infos = (List)entry.getValue();
            INotePayable pay = (INotePayable)BankBundleManager.getInstance().getImplByClassName(bankVersionID, INotePayable.class, implClass);
            int batchSize = pay.getBatchSize();
            if (batchSize < 1) {
                batchSize = 1;
            }
            if (infos.size() <= batchSize) {
                NotePayableConvert.addBankSeqID(bankVersionID, infos);
                result.add(infos);
                continue;
            }
            for (int startIndex = 0; startIndex < infos.size(); startIndex += batchSize) {
                int endIndex = startIndex + batchSize;
                if (endIndex > infos.size()) {
                    endIndex = infos.size();
                }
                List<NotePayableInfo> temp = infos.subList(startIndex, endIndex);
                result.add(temp);
                NotePayableConvert.addBankSeqID(bankVersionID, temp);
            }
        }
        return result;
    }

    private static void formateNo(NotePayableDetail notePayableDetail) {
        notePayableDetail.setStartNo(NoteRngNoUtils.getResponseNo(notePayableDetail.getStartNo()));
        notePayableDetail.setEndNo(NoteRngNoUtils.getResponseNo(notePayableDetail.getEndNo()));
        notePayableDetail.setSubRange(NoteRngNoUtils.getResponseNoRange(notePayableDetail.getSubRange()));
    }
}

