/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.citic.dc.service.codeless.detail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.citic.dc.service.codeless.detail.endorseinfo.EndorseInfoImpl;
import kd.ebg.note.business.PackerUtil.PackerUtil;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import org.jdom2.Element;

public class CodelessNoteHoldImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CodelessNoteHoldImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLFETQJB";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u53ca\u6301\u6709\u7968\u636e\u67e5\u8be2", (String)"CodelessNoteHoldImpl0", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLFETQJB");
        JDomUtils.addChild((Element)root, (String)"reqCode", (String)"DLFETQJB");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)Sequence.gen14Sequence());
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)root, (String)"startDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now().plusMonths(-6L)));
        JDomUtils.addChild((Element)root, (String)"endDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now().plusMonths(6L)));
        JDomUtils.addChild((Element)root, (String)"minAmt", (String)"0");
        JDomUtils.addChild((Element)root, (String)"maxAmt", (String)"9999999999");
        JDomUtils.addChild((Element)root, (String)"queryType", (String)"DLFETQJB");
        JDomUtils.addChild((Element)root, (String)"rcdNum", (String)"20");
        JDomUtils.addChild((Element)root, (String)"startNo", (String)pageTag);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        ArrayList<Detail> result = new ArrayList<Detail>(1);
        String encoding = RequestContextUtils.getCharset();
        Element stream = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String status = stream.getChildTextTrim("status");
        if (!status.equals("AAAAAAA")) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5f02\u5e38", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]));
        }
        Element list = stream.getChild("list");
        List rows = list.getChildren("row");
        Map map = this.getStructMapPacker();
        String structId = this.getStructIdSide();
        EndorseInfoImpl impl = new EndorseInfoImpl();
        for (Element rs : rows) {
            String expDt;
            Detail detail = new Detail();
            String billStat = stream.getChildTextTrim("billStat");
            detail.setNoteStatus(billStat);
            if ("CS06".equals(billStat) || "CS05".equals(billStat)) continue;
            result.add(detail);
            String fixBillPkgid = rs.getChildTextTrim("fixBillPkgid");
            detail.setNoteNo(fixBillPkgid);
            String fixSubBillRng = rs.getChildTextTrim("fixSubBillRng");
            detail.setSubRange(fixSubBillRng);
            String issupprDt = stream.getChildTextTrim("issupprDt");
            if (StringUtils.isNotEmpty((String)issupprDt)) {
                detail.setIssueDate(issupprDt.replaceAll("-", ""));
            }
            if (StringUtils.isNotEmpty((String)(expDt = stream.getChildTextTrim("expDt")))) {
                detail.setDueDate(expDt);
            }
            String billTp = stream.getChildTextTrim("billTp");
            detail.setDraftType(billTp);
            String billfaceAmt = stream.getChildTextTrim("billfaceAmt");
            detail.setAmount(billfaceAmt);
            String tfrFlagNm = stream.getChildTextTrim("tfrFlagNm");
            detail.setTransferFlag(tfrFlagNm);
            String rmtrNm = stream.getChildTextTrim("rmtrNm");
            detail.setDrawerAccName(rmtrNm);
            String drwrAcc = stream.getChildTextTrim("drwrAcc");
            detail.setDrawerAccNo(drwrAcc);
            String rmtrDepbnkNm = stream.getChildTextTrim("rmtrDepbnkNm");
            detail.setDrawerBankName(rmtrDepbnkNm);
            String rmtrDepbnkBrcode = stream.getChildTextTrim("rmtrDepbnkBrcode");
            detail.setDrawerCnapsCode(rmtrDepbnkBrcode);
            String payeeNm = stream.getChildTextTrim("payeeNm");
            detail.setPayeeAccName(payeeNm);
            String pyeeAcc = stream.getChildTextTrim("pyeeAcc");
            detail.setPayeeAccNo(pyeeAcc);
            String payeeDepbnkNm = stream.getChildTextTrim("payeeDepbnkNm");
            detail.setPayeeBankName(payeeDepbnkNm);
            String payeeDepbnkBrcode = stream.getChildTextTrim("payeeDepbnkBrcode");
            detail.setPayeeCnapsCode(payeeDepbnkBrcode);
            String accpNam = stream.getChildTextTrim("accpNam");
            detail.setPayeeAccName(accpNam);
            String accpAcc = stream.getChildTextTrim("accpAcc");
            detail.setPayeeAccNo(accpAcc);
            String acptrDepbnkNm = stream.getChildTextTrim("acptrDepbnkNm");
            detail.setPayeeBankName(acptrDepbnkNm);
            String acptrDepbnkBrcode = stream.getChildTextTrim("acptrDepbnkBrcode");
            detail.setPayeeCnapsCode(acptrDepbnkBrcode);
            String fixCrclFlag = stream.getChildTextTrim("fixCrclFlag");
            detail.setCirStatus(fixCrclFlag);
            try {
                String rsp = PackerUtil.packerInfo((Detail)detail, (Map)map, (String)structId, (String)this.getDateStr(), (String)request.getAcnt().getAccNo());
                String responseStr2 = this.doBussiness(rsp);
                List<Detail> info = impl.parse(request, responseStr2);
                List noteSidesInfos = info.get(0).getNoteSidesInfo();
                noteSidesInfos = this.sortSide(noteSidesInfos);
                detail.setNoteSidesInfo(noteSidesInfos);
            }
            catch (Throwable t) {
                this.logger.error("sides error", t);
                detail.setIsNoteSidesError("Y");
            }
        }
        return result;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        String encoding = RequestContextUtils.getCharset();
        Element stream = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element list = stream.getChild("list");
        List row = list.getChildren("row");
        int i = Integer.parseInt(pageTag) + row.size();
        return i + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        String encoding = RequestContextUtils.getCharset();
        Element stream = JDomUtils.string2Root((String)rspStr, (String)encoding);
        String totalNum = stream.getChildTextTrim("totalNum");
        return Integer.parseInt(totalNum) < Integer.parseInt(pageTag);
    }

    public List<Detail> getSideImpl(List<Detail> details) {
        EBContext context = EBContext.getContext();
        String accno = context.getAcnt().getAccNo();
        String dateStr = this.getDateStr();
        Map map = this.getStructMapPacker();
        String structId = this.getStructIdSide();
        EndorseInfoImpl impl = new EndorseInfoImpl();
        BankNoteDetailRequest request = new BankNoteDetailRequest();
        for (Detail detail : details) {
            String rsp = PackerUtil.packerInfo((Detail)detail, (Map)map, (String)structId, (String)dateStr, (String)accno);
            String responseStr = this.doBussiness(rsp);
            List<Detail> info = impl.parse(request, responseStr);
            try {
                List noteSidesInfos = info.get(0).getNoteSidesInfo();
                noteSidesInfos = this.sortSide(noteSidesInfos);
                detail.setNoteSidesInfo(noteSidesInfos);
            }
            catch (Throwable t) {
                this.logger.error("sides error", t);
                detail.setIsNoteSidesError("Y");
            }
        }
        return details;
    }

    public boolean isCodelessSide() {
        return true;
    }

    public boolean revertSide() {
        return true;
    }
}

