/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.citic.dc.service.note.receivable.discount;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.citic.dc.service.note.ParserProxy;
import kd.ebg.note.banks.citic.dc.service.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.citic.dc.service.note.status.CheckOperateReceive;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLTIEXSQ";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        boolean flag = new CheckOperateReceive().checkStatus((NoteReceivableInfo)noteReceivableInfos.get(0), "11");
        if (!flag) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u8fd4\u56de\u65e0\u6cd5\u8d34\u73b0\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u3002", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]));
        }
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLTIEXSQ");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getDrawerAccNo());
        JDomUtils.addChild((Element)root, (String)"billNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getBillNo());
        JDomUtils.addChild((Element)root, (String)"dsbkIsCitic", (String)("1".equals(DiscountNoteReceivableImpl.isSamebank(((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeBankName())) ? "0" : "1"));
        JDomUtils.addChild((Element)root, (String)"dsbkName", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeAccName());
        if ("1".equals(DiscountNoteReceivableImpl.isSamebank(((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeBankName()))) {
            JDomUtils.addChild((Element)root, (String)"dsbkAccNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeAccNo());
        } else {
            JDomUtils.addChild((Element)root, (String)"dsbkAccNo", (String)"0");
        }
        JDomUtils.addChild((Element)root, (String)"dsbkBnm", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeBankCnaps());
        JDomUtils.addChild((Element)root, (String)"dscntType", (String)"RM00");
        JDomUtils.addChild((Element)root, (String)"rpdStartDate", (String)"");
        JDomUtils.addChild((Element)root, (String)"rpdDueDate", (String)"");
        JDomUtils.addChild((Element)root, (String)"rpdRate", (String)"");
        JDomUtils.addChild((Element)root, (String)"rpdAmt", (String)"");
        JDomUtils.addChild((Element)root, (String)"dscntRate", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getDisCountRate());
        JDomUtils.addChild((Element)root, (String)"aoaiAccNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getAcceptorAccNo());
        JDomUtils.addChild((Element)root, (String)"aoaiBnm", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getAcceptorBankCnaps());
        JDomUtils.addChild((Element)root, (String)"endorseMk", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getTransferFlag());
        JDomUtils.addChild((Element)root, (String)"realAmt", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getDisCountAmount());
        if ("1".equals(((NoteReceivableInfo)noteReceivableInfos.get(0)).getDiscountType())) {
            JDomUtils.addChild((Element)root, (String)"inteMthd", (String)"02");
        } else if ("2".equals(((NoteReceivableInfo)noteReceivableInfos.get(0)).getDiscountType())) {
            JDomUtils.addChild((Element)root, (String)"inteMthd", (String)"01");
        } else {
            JDomUtils.addChild((Element)root, (String)"inteMthd", (String)"03");
        }
        JDomUtils.addChild((Element)root, (String)"payMthd", (String)"");
        JDomUtils.addChild((Element)root, (String)"contractNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"invoiceNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"ecdsBatNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"memo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"preDate", (String)"");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public static String isSamebank(String accno) {
        if (StringUtils.isEmpty((String)accno)) {
            return "1";
        }
        return SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)accno);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return noteReceivableInfos;
    }
}

