/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.util;

import java.util.Date;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.services.util.Constants;
import kd.ebg.note.banks.spdb.dc.services.util.Utils;
import org.jdom2.Element;

public class Packer
implements Constants {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(Packer.class);

    public static Element createMessageWithHead(String trcode) throws EBServiceException {
        return Packer.createHeadMessage(trcode);
    }

    public static String packToReqMsg(String txCode, String signature) {
        Element packet = new Element("packet");
        Element head = JDomUtils.addChild((Element)packet, (String)"head");
        JDomUtils.addChild((Element)head, (String)"transCode", (String)txCode);
        JDomUtils.addChild((Element)head, (String)"signFlag", (String)"1");
        JDomUtils.addChild((Element)head, (String)"masterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        JDomUtils.addChild((Element)head, (String)"packetID", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)head, (String)"timeStamp", (String)Utils.formatDate4Persion(new Date()));
        Element body = JDomUtils.addChild((Element)packet, (String)"body");
        JDomUtils.addChild((Element)body, (String)"signature", (String)signature);
        String msg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)packet, (String)RequestContextUtils.getCharset());
        String encoding = RequestContextUtils.getCharset();
        String length = "" + (Utils.getLength4DataWithEncoding(msg, encoding) + 6);
        StringBuilder buffer = new StringBuilder();
        buffer.append(Utils.fixedLength(length, " ", 6));
        buffer.append(msg);
        return buffer.toString();
    }

    private static Element createHeadMessage(String trcode) throws EBServiceException {
        Element packet = new Element("packet");
        Element head = JDomUtils.addChild((Element)packet, (String)"head");
        JDomUtils.addChild((Element)head, (String)"transCode", (String)trcode);
        JDomUtils.addChild((Element)head, (String)"signFlag", (String)"1");
        JDomUtils.addChild((Element)head, (String)"masterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        JDomUtils.addChild((Element)head, (String)"yqzlNo");
        JDomUtils.addChild((Element)head, (String)"packetID", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)head, (String)"timeStamp", (String)Utils.formatDate4Persion(new Date()));
        return packet;
    }

    public static Element creatCycleMessage() throws EBServiceException {
        Element lists = new Element("lists");
        lists.setAttribute("name", "edraftList");
        return lists;
    }
}

