/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryNoteStatusPacker {
    public static String packQueryPayable(List<NotePayableInfo> notePayableInfos, String tranCode) {
        NotePayableInfo info = notePayableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH026", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"BKTYPE", (String)info.getDraftType());
        String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
        JDomUtils.addChild((Element)txBody, (String)"Bk10Date1", (String)signDate4Test);
        JDomUtils.addChild((Element)txBody, (String)"Bk10Date2", (String)signDate4Test);
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date3", (String)info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date4", (String)info.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAmt1", (String)info.getAmount().toString());
        JDomUtils.addChild((Element)txBody, (String)"BkAmt2", (String)info.getAmount().toString());
        if (info.getBillNo().length() == 30) {
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getBillNo());
        }
        JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)tranCode);
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public static String packQueryPay(List<NoteReceivableInfo> notePayableInfos, String tranCode) {
        NoteReceivableInfo info = notePayableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH026", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"BKTYPE", (String)info.getDraftType());
        String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
        if (StringUtils.isNotEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)txBody, (String)"Bk10Date1", (String)signDate4Test);
            JDomUtils.addChild((Element)txBody, (String)"Bk10Date2", (String)signDate4Test);
        } else {
            JDomUtils.addChild((Element)txBody, (String)"Bk10Date1", (String)info.getReserved1());
            JDomUtils.addChild((Element)txBody, (String)"Bk10Date2", (String)info.getReserved1());
        }
        JDomUtils.addChild((Element)txBody, (String)"Bk10Date1", (String)signDate4Test);
        JDomUtils.addChild((Element)txBody, (String)"Bk10Date2", (String)signDate4Test);
        JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getBillNo());
        JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)tranCode);
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public static String packQueryResponsePayable(List<NotePayableInfo> notePayableInfos, String transType) {
        NotePayableInfo info = notePayableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH041", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"ECTYPEVALUE", (String)info.getDraftType());
        JDomUtils.addChild((Element)txBody, (String)"TRANTYPE", (String)transType);
        LocalDateTime searchDate = info.getSubmitSuccessTime();
        if (searchDate == null) {
            searchDate = info.getInsertTime();
        }
        JDomUtils.addChild((Element)txBody, (String)"BEGINDATE", (String)searchDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"ENDDATE", (String)searchDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"RESPONSE", (String)info.getOtherInfo());
        JDomUtils.addChild((Element)txBody, (String)"BkFlag3");
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public static String packQueryResponsePay(List<NoteReceivableInfo> receivableInfos, String transType, String pageTag) {
        return QueryNoteStatusPacker.packQueryResponsePay(receivableInfos, transType, "SU00", pageTag);
    }

    public static String packQueryResponsePay(List<NoteReceivableInfo> receivableInfos, String transType, String signType, String pageTag) {
        String signDate4Test;
        NoteReceivableInfo info = receivableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH041", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"ECTYPEVALUE", (String)info.getDraftType());
        JDomUtils.addChild((Element)txBody, (String)"TRANTYPE", (String)transType);
        LocalDateTime searchDate = info.getSubmitSuccessTime();
        if (searchDate == null) {
            searchDate = info.getInsertTime();
        }
        if (StringUtils.isEmpty((String)(signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE")))) {
            JDomUtils.addChild((Element)txBody, (String)"BEGINDATE", (String)searchDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)txBody, (String)"ENDDATE", (String)searchDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        } else {
            JDomUtils.addChild((Element)txBody, (String)"BEGINDATE", (String)signDate4Test);
            JDomUtils.addChild((Element)txBody, (String)"ENDDATE", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)txBody, (String)"RESPONSE", (String)info.getOtherInfo());
        JDomUtils.addChild((Element)txBody, (String)"BkFlag3");
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTag);
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        JDomUtils.addChild((Element)txBody, (String)"BkListNo2", (String)info.getBillNo());
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public static String packQueryByPage(List<NoteReceivableInfo> receivableInfos, String pageTap) {
        NoteReceivableInfo info = receivableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH048", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getObssid());
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTap);
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public static String packByPage(List<NotePayableInfo> notePayableInfos, String pageTap) {
        NotePayableInfo info = notePayableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH048", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getObssid());
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTap);
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }
}

