/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.detail.BusCodeUtil;
import kd.ebg.note.banks.ccb.dc.services.note.detail.holdinfo.EndorseInfoImpl;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import org.jdom2.Element;

public class NoteDetailHoldImpl
extends AbstractNoteDetailImpl {
    public static final int PAGE_SIZE = 50;
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailHoldImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "NoteDetailImpl";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6301\u7968\u67e5\u8be2", (String)"NoteDetailHoldImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            this.logger.info("\u603b\u6570\u4e3a" + pageTotalNumStr);
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(pageTag) - 1;
                boolean bl = flag = page * 50 >= pageTotalNum;
                if (pageTotalNum < 50) {
                    flag = true;
                }
            }
        } else {
            flag = true;
        }
        this.logger.info("\u8fdb\u5165\u64a4\u9500\u5206\u9875" + flag);
        return flag;
    }

    public boolean isNeedPage() {
        return false;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        BankAcnt ancAcnt = request.getAcnt();
        return this.packNoteDetailRequset(request, pageTag, ancAcnt);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        BankAcnt ancAcnt = request.getAcnt();
        return this.parseNoteInfoDetail(request, responseStr, ancAcnt);
    }

    public String packNoteDetailRequset(BankNoteDetailRequest request, String pageTag, BankAcnt ancAcnt) {
        return this.packQueryReplayRequst(request, pageTag, ancAcnt);
    }

    private String packQueryReplayRequst(BankNoteDetailRequest request, String pageTag, BankAcnt ancAcnt) {
        Element root = CCB_DC_Packer.createTransactionHeader("6WH032", Sequence.gen16NumSequence() + "");
        Element txBody = NoteCommonPacker.createTransactionBody(root);
        pageTag = request.getBody().getPageNum() == 0 ? "1" : request.getBody().getPageNum() + "";
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTag);
        JDomUtils.addChild((Element)txBody, (String)"BKTYPE", (String)"AC01");
        JDomUtils.addChild((Element)txBody, (String)"BkFlag1", (String)"0");
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date2", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkAmt1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkAmt2", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"50");
        return NoteCommonPacker.root2StringSafeMod(root);
    }

    public List<Detail> parseNoteInfoDetail(BankNoteDetailRequest rqst, String rspStr, BankAcnt ancAcnt) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        ArrayList<Detail> result = new ArrayList();
        if (!"000000".equals(rspCode)) {
            throw EBExceiptionUtil.serviceException((String)("hold query error:" + response.getResponseMessage()));
        }
        Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
        Element detailListNode = JDomUtils.getChildElement((Element)txBody, (String)"DETAILLIST");
        List detailLists = detailListNode.getChildren("DETAILINFO");
        result = this.getDetails(rqst, detailLists, ancAcnt);
        return result;
    }

    private List<Detail> getDetails(BankNoteDetailRequest rqst, List<Element> detailLists, BankAcnt ancAcnt) {
        ArrayList<Detail> result = new ArrayList<Detail>();
        for (Element node : detailLists) {
            Detail info = new Detail();
            String bankCode = JDomUtils.getChildText((Element)node, (String)"BkListNo1");
            String ebgCode = BusCodeUtil.INSTANCE.convert2Bank(bankCode);
            info.setBusinessCode(ebgCode);
            info.setNoteNo(JDomUtils.getChildText((Element)node, (String)"BkListNo1"));
            info.setHolderAccNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo1"));
            info.setHolderBankName(rqst.getAcnt().getBankName());
            info.setHolderCnapsCode(rqst.getAcnt().getCnaps());
            info.setPreHolderName(rqst.getAcnt().getAccName());
            info.setDraftType(JDomUtils.getChildText((Element)node, (String)"BkType1"));
            info.setAcceptorAccName(JDomUtils.getChildText((Element)node, (String)"Bk60Name3"));
            info.setAcceptorCnapsCode(JDomUtils.getChildText((Element)node, (String)"BkBrchNo2"));
            info.setAcceptorAccNo(JDomUtils.getChildText((Element)node, (String)"BkAcctNo2"));
            String amount = JDomUtils.getChildText((Element)node, (String)"BkAmt1");
            info.setAmount(amount);
            String dueStartDate = JDomUtils.getChildText((Element)node, (String)"Bk8Date1");
            if (!StringUtils.isEmpty((String)dueStartDate)) {
                info.setIssueDate(dueStartDate);
            }
            String dueDate = JDomUtils.getChildText((Element)node, (String)"Bk8Date2");
            info.setDueDate(dueDate);
            String BkFlag1 = JDomUtils.getChildText((Element)node, (String)"BkFlag1");
            info.setNoteStatus(BkFlag1);
            String BkAcctNo7 = JDomUtils.getChildText((Element)node, (String)"BkAcctNo1");
            if (!ancAcnt.getAccNo().equals(BkAcctNo7)) continue;
            try {
                EndorseInfoImpl impl = new EndorseInfoImpl();
                info = impl.getinfo(info);
            }
            catch (Exception e) {
                this.logger.error("hold bill query endorseInfo error:", (Throwable)e);
                continue;
            }
            result.add(info);
        }
        return result;
    }
}

