/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.detail.holdinfo;

import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.banks.ccb.dc.services.note.detail.holdinfo.NoteInfoPacker;
import kd.ebg.note.banks.ccb.dc.services.note.detail.holdinfo.NoteInfoParser;
import kd.ebg.note.common.entity.biz.notedetail.Detail;

public class EndorseInfoImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseInfoImpl.class);

    public Detail getinfo(Detail info) {
        NoteInfoPacker packer = new NoteInfoPacker();
        NoteInfoParser parse = new NoteInfoParser();
        String rqstStr = packer.packNoteInfoRequest(info.getNoteNo());
        boolean isRetry = false;
        String rspStr = "";
        int count = 0;
        while (true) {
            try {
                rspStr = this.getResponStr(rqstStr);
                info = parse.parserNoteInfoResponse(rspStr, info);
                return info;
            }
            catch (Exception e) {
                isRetry = true;
                this.logger.info("query error ,try again", (Object)(++count));
                if (isRetry && count < 3) continue;
                if (count >= 3) {
                    throw EBExceiptionUtil.serviceException((String)"query have been try 3 times,refused");
                }
                return info;
            }
            break;
        }
    }

    public String getResponStr(String rqstStr) {
        String rspStr = "";
        try {
            NoteInfoPacker packer = new NoteInfoPacker();
            NoteInfoParser parse = new NoteInfoParser();
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            String encoding = RequestContextUtils.getCharset();
            factory.setHttpHeader("content-type", "text/xml; charset=" + encoding);
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                try (InputStream is = conn.getInputStream();){
                    rspStr = IOUtils.readFully((InputStream)is);
                    conn.closeConnection();
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u80cc\u4e66\u8054\u67e5\u8be2\u5f02\u5e38\uff1a%1$s\u3002", (String)"EndorseInfoImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), e.getMessage()));
        }
        return rspStr;
    }
}

