/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.payable.register.FileUtil;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CCB_DCFileUtil
extends AbstractImpl {
    private static String uploadFile = "BatchSalaryPayment";
    private static String downloadFile = "BatchSalaryQueryPayment";
    private static String fileStart = "KDfileStart";

    public String uploadFile(String fileName, String fileContent) {
        try {
            String rqstStr = this.packUplaodFileXML(fileName, fileContent);
            String rspStr = this.sendAndRecvMsg(rqstStr);
            return this.parseUplaodFileXML(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public Map<String, String> uploadFileMD5(String fileName, String fileContent) {
        try {
            String rqstStr = this.packUplaodFileXML(fileName, fileContent);
            String rspStr = this.sendAndRecvMsg(rqstStr);
            return this.parseUplaodFileXMLMD5(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String downloadFile(String fileName) {
        try {
            String rqstStr = this.packDownlaodFileXML(fileName);
            String rspStr = this.sendAndRecvMsg(rqstStr);
            return this.parseDownlaodFileXML(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private String packUplaodFileXML(String fileName, String fileContent) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = CCB_DCFileUtil.createHead(uploadFile);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"file", (String)fileName);
        JDomUtils.addChild((Element)reqPara, (String)"fileContent", (String)fileContent);
        return JDomUtils.root2String((Element)simulator, (String)"UTF-8");
    }

    private String packDownlaodFileXML(String fileName) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = CCB_DCFileUtil.createHead(downloadFile);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName);
        return JDomUtils.root2String((Element)simulator, (String)"UTF-8");
    }

    private String parseUplaodFileXML(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"UTF-8");
        BankResponse rsp = CCB_DCFileUtil.parseHeader(root);
        if (!"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ,%1$S ,%2$S", (String)"CCB_DCFileUtil_7", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"CCB_DCFileUtil_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equals(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 ,%1$s,%2$s", (String)"CCB_DCFileUtil_8", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        Element filContent = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"fileContent");
        String fileName = filContent.getTextTrim();
        return fileName;
    }

    private Map<String, String> parseUplaodFileXMLMD5(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"UTF-8");
        BankResponse rsp = CCB_DCFileUtil.parseHeader(root);
        if (!"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ,%1$s,%2$s", (String)"CCB_DCFileUtil_9", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"CCB_DCFileUtil_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equals(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 ,%1$s,%2$s", (String)"CCB_DCFileUtil_8", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        Element filContent = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"fileContent");
        String MD5 = JDomUtils.getChildText((Element)rspPara, (String)"MD5");
        HashMap<String, String> map = new HashMap<String, String>();
        String fileName = filContent.getTextTrim();
        map.put("fileName", fileName);
        map.put("MD5", MD5);
        return map;
    }

    private String parseDownlaodFileXML(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"UTF-8");
        BankResponse rsp = CCB_DCFileUtil.parseHeader(root);
        if (!"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 ,%1$s ,%2$s", (String)"CCB_DCFileUtil_10", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"CCB_DCFileUtil_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equals(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25 ,%1$s %2$s", (String)"CCB_DCFileUtil_11", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        String fileContent = JDomUtils.getChildTextTrim((Element)rspPara, (String)"fileContent");
        return fileContent;
    }

    public static Element createHead(String bizType) {
        return CCB_DCFileUtil.createHead(bizType, Sequence.genSequence());
    }

    public static Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        TimeZone china = TimeZone.getTimeZone("GMT+:08:00");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date(), (TimeZone)china));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.formatTime((Date)new Date(), (TimeZone)china));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"CCB_DCFileUtil_5", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    private String sendAndRecvMsg(String rqstStr) throws Exception {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String portStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_port");
        String timeOutStr = RequestContextUtils.getBankParameterValue((String)"timeout");
        int port = Integer.parseInt(portStr);
        int timeOut = Integer.parseInt(timeOutStr);
        HashMap header = new HashMap();
        HttpConnection conn = new HttpConnection(ip, port, "", header, timeOut);
        this.openConnection((IConnection)conn);
        String rspStr = "";
        try (OutputStream os = this.getOutputStream((IConnection)conn);){
            IOUtils.sendFully((OutputStream)os, (String)rqstStr, (String)"UTF-8");
            try (InputStream is = this.getInputStream((IConnection)conn);){
                rspStr = IOUtils.readFully((InputStream)is, (String)"UTF-8");
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (String)"CCB_DCFileUtil_6", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (String)"CCB_DCFileUtil_6", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return rspStr;
    }
}

