/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.payable.receive;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.payable.cancle.StatusUtil;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_NotePacker;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Parser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryReceiveNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryReceiveNotePayableImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QBIPCOL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u67e5\u8be2", (String)"QueryReceiveNotePayableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot("QBIPCOL");
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"QryfSeqno", (String)((NotePayableInfo)request.getNotePayableInfoList().get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)in, (String)"QrySerialNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, "QBIPCOL");
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo notePayableInfo = (NotePayableInfo)notePayableInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String SerialNo = pub.getChildText("SerialNo");
        logger.info("SerialNo:{}", (Object)SerialNo);
        String fSeqno = pub.getChildText("fSeqno");
        logger.info("fSeqno:{}", (Object)fSeqno);
        notePayableInfo.setRspserialno(SerialNo);
        notePayableInfo.setRqstserialno(fSeqno);
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        logger.info("parsePay RetCode=" + headRsp.getResponseCode() + ", parsePay RetMsg=" + headRsp.getResponseMessage());
        if (!"0".equals(headRsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        Element out = eb.getChild("out");
        String outstr = JDomUtils.element2StringPlain((Element)out, (String)"UTF-8");
        logger.info("outstr \u4e2d\u62a5\u6587\u662f\uff1a" + outstr);
        String resultstr = out.getChildTextTrim("Result");
        logger.info("outstr \u4e2dresult\u662f\uff1a" + resultstr + ",\u662f\u5426\u4e3a15:" + resultstr.equals("15"));
        if (out == null) {
            if (notePayableInfos.size() != 0) {
                EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
                return notePayableInfos;
            }
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankStatus, (String)headRsp.getResponseMessage());
            return notePayableInfos;
        }
        String result = out.getChildTextTrim("Result");
        if (result.equals("0")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u94f6\u884c\u5904\u7406\u3002", (String)"QueryReceiveNotePayableImpl_1", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("1")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f\uff0c\u7b49\u5f85\u94f6\u884c\u5904\u7406\uff08\u9884\u7559\uff09\u3002", (String)"QueryReceiveNotePayableImpl_2", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("2")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u7b49\u5f85\u6388\u6743\uff08\u9884\u7559\uff09\u3002", (String)"QueryReceiveNotePayableImpl_3", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("6")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.FAIL, (String)result, (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"QueryReceiveNotePayableImpl_4", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("7")) {
            logger.info("\u63d0\u793a\u6536\u7968\u540c\u6b65\u8fd4\u56de7\uff0c\u53ef\u4ee5\u7b97\u7ed3\u675f\u4e86");
            notePayableInfo.setNoteStatus("030001");
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f", (String)"QueryReceiveNotePayableImpl_5", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("9")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)result, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6b63\u5728\u5904\u7406", (String)"QueryReceiveNotePayableImpl_6", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("15")) {
            notePayableInfo.setNoteStatus("030006");
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u6210\u529f\u3002", (String)"QueryReceiveNotePayableImpl_7", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        } else if (result.equals("16")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.FAIL, (String)result, (String)ResManager.loadKDString((String)"\u6307\u4ee4\u63d0\u4ea4\u6210\u529f\uff0c\u4eba\u884c\u5904\u7406\u5931\u8d25\u3002", (String)"QueryReceiveNotePayableImpl_8", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)notePayableInfo.getNoteStatus())) {
            NotePayableInfo[] infos = request.getNotePayableInfosAsArray();
            String msg = ICBC_CMP_NotePacker.packQueryDetailPayableXml(infos);
            String returnmsg = new StatusUtil().sendAndRecvMsg(msg);
            notePayableInfo.setNoteStatus(this.getstatus(infos, returnmsg));
        }
        return notePayableInfos;
    }

    public String getstatus(NotePayableInfo[] notePayableInfos, String rspStr) {
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rspStr, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankMsg = headRsp.getResponseMessage();
        if (!"0".equals(headRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u540c\u6b65\u7ed3\u679c\u5931\u8d25", (String)"QueryReceiveNotePayableImpl_9", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]));
        }
        Element out = eb.getChild("out");
        String BillNo = out.getChildTextTrim("BillNo");
        String result = out.getChildTextTrim("BillState");
        return result;
    }

    public int getBatchSize() {
        return 1;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        NotePayableInfo notePayableInfo = (NotePayableInfo)request.getNotePayableInfoList().get(0);
        if (notePayableInfo.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.payable.receive.QueryReceiveNotePayableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.payable.receive.QueryReceiveNotePayableImpl();
            return impl.doBiz(request);
        }
        return super.doBiz(request);
    }
}

