/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class NoteStatusUtil
extends AbstractImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(NoteStatusUtil.class);
    private static final Map<String, String> cancelTypeMap = new HashMap<String, String>();
    public static final NoteStatusUtil INSTANCE = new NoteStatusUtil();

    public String convert2Bank(String ebgTypeCode) {
        return cancelTypeMap.get(ebgTypeCode);
    }

    public NoteReceivableInfo queryOperableNoteDetails(NoteReceivableInfo noteReceivableInfo, String bizType) {
        InputStream is = null;
        OutputStream os = null;
        try {
            String rqstStr = this.packOperableNoteDetail(noteReceivableInfo, bizType);
            ConnectionFactory factory = this.getConnectionFactory();
            IConnection conn = this.getConnection(factory);
            this.openConnection(conn);
            os = this.getOutputStream(conn);
            this.send(os, rqstStr);
            this.closeOutputStreamQuietly(os);
            is = this.getInputStream(conn);
            String rspStr = this.recv(is);
            this.closeInputStreamQuietly(is);
            NoteReceivableInfo noteReceivableInfo2 = this.parseOperableNoteDetail(noteReceivableInfo, rspStr);
            return noteReceivableInfo2;
        }
        catch (Exception var8) {
            throw EBExceiptionUtil.serviceException((Throwable)var8);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                }
            }
        }
    }

    public String packOperableNoteDetail(NoteReceivableInfo info, String bizType) {
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element NEWEBOPRNQUERYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBOPRNQUERYTRNRQ");
        JDomUtils.addChild((Element)NEWEBOPRNQUERYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element RQBODY = JDomUtils.addChildAttribute((Element)NEWEBOPRNQUERYTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        RQBODY.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)RQBODY, (String)"RDYAPPLYBIZTYPE", (String)bizType);
        JDomUtils.addChild((Element)RQBODY, (String)"DRAFTNO", (String)info.getBillNo());
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public NoteReceivableInfo parseOperableNoteDetail(NoteReceivableInfo noteReceivableInfo, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        if (!"0".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u62a5\u9519\uff0c\u672a\u67e5\u8be2\u5230\u8be5\u7968\u636e\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001", (String)"NoteStatusUtil_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element NEWEBOPRNQUERYTRNRS = eb1.getChild("NEWEBOPRNQUERYTRNRS");
        Element RSBODY = NEWEBOPRNQUERYTRNRS.getChild("RSBODY");
        boolean flag = false;
        if (RSBODY != null) {
            List contentList = RSBODY.getChildren("CONTENT");
            for (int i = 0; i < contentList.size(); ++i) {
                Element rs = (Element)contentList.get(i);
                String DRAFTNO = JDomUtils.getChildText((Element)rs, (String)"DRAFTNO");
                String DRAFTRANGE = JDomUtils.getChildText((Element)rs, (String)"DRAFTRANGE");
                String SPLITFLAG = JDomUtils.getChildText((Element)rs, (String)"SPLITFLAG");
                String DRAFTAMT = JDomUtils.getChildText((Element)rs, (String)"DRAFTAMT");
                if (!DRAFTNO.equals(noteReceivableInfo.getBillNo())) continue;
                if ("1".equals(SPLITFLAG) && DRAFTRANGE.indexOf(",") > -1) {
                    if (!noteReceivableInfo.getSubRange().equals(DRAFTRANGE)) continue;
                    flag = true;
                    noteReceivableInfo.setReserved4(DRAFTAMT);
                    break;
                }
                flag = true;
                noteReceivableInfo.setReserved4(DRAFTAMT);
                break;
            }
        }
        if (!flag) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u6027\u7968\u636e\u67e5\u8be2\u7968\u636e\u8303\u56f4\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u64cd\u4f5c\u5931\u8d25\uff01", (String)"NoteStatusUtil_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        return noteReceivableInfo;
    }

    public String packOperableNoteDetails(NoteReceivableInfo info, String bizType) {
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element NEWEBOPRNQUERYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBOPRNQUERYTRNRQ");
        JDomUtils.addChild((Element)NEWEBOPRNQUERYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element RQBODY = JDomUtils.addChildAttribute((Element)NEWEBOPRNQUERYTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        RQBODY.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)RQBODY, (String)"RDYAPPLYBIZTYPE", (String)bizType);
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public NoteReceivableInfo[] parseOperableNoteDetails(NoteReceivableInfo[] noteReceivableInfos, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        this.logger.info("\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\uff1a" + rspStr);
        if (!"0".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u62a5\u9519\uff0c\u672a\u67e5\u8be2\u5230\u8be5\u7968\u636e\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001", (String)"NoteStatusUtil_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element NEWEBOPRNQUERYTRNRS = eb1.getChild("NEWEBOPRNQUERYTRNRS");
        Element RSBODY = NEWEBOPRNQUERYTRNRS.getChild("RSBODY");
        if (RSBODY != null) {
            List contentList = RSBODY.getChildren("CONTENT");
            for (int i = 0; i < contentList.size(); ++i) {
                Element rs = (Element)contentList.get(i);
                String DRAFTNO = JDomUtils.getChildText((Element)rs, (String)"DRAFTNO");
                String DRAFTRANGE = JDomUtils.getChildText((Element)rs, (String)"DRAFTRANGE");
                String SPLITFLAG = JDomUtils.getChildText((Element)rs, (String)"SPLITFLAG");
                String DRAFTAMT = JDomUtils.getChildText((Element)rs, (String)"DRAFTAMT");
                for (NoteReceivableInfo noteReceivableInfo : noteReceivableInfos) {
                    String[] FixSubBillRng;
                    if (!DRAFTNO.equals(noteReceivableInfo.getBillNo())) continue;
                    if ("1".equals(SPLITFLAG) && DRAFTRANGE.indexOf(",") > -1 && (FixSubBillRng = DRAFTRANGE.split(",")).length > 1) {
                        String startNoStr = FixSubBillRng[0];
                        String endNoStr = FixSubBillRng[1];
                        int startNumber = Integer.parseInt(startNoStr);
                        int endNumber = Integer.parseInt(endNoStr);
                        String origStartNo = noteReceivableInfo.getStartNo();
                        String origEndNo = noteReceivableInfo.getEndNo();
                        if (origStartNo == null || origEndNo == null) {
                            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u672a\u4e0a\u9001\u7968\u636e\u8303\u56f4", (String)"NoteStatusUtil_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                        }
                        int origStartNumber = Integer.parseInt(origStartNo);
                        int origEndNumber = Integer.parseInt(origEndNo);
                        if (startNumber >= origStartNumber && endNumber <= origEndNumber) {
                            noteReceivableInfo.setStartNo(startNoStr);
                            noteReceivableInfo.setEndNo(endNoStr);
                        } else {
                            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u6027\u7968\u636e\u67e5\u8be2\u7968\u636e\u8303\u56f4\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u64cd\u4f5c\u5931\u8d25\uff01", (String)"NoteStatusUtil_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                        }
                    }
                    noteReceivableInfo.setReserved4(DRAFTAMT);
                }
            }
        }
        return noteReceivableInfos;
    }

    static {
        cancelTypeMap.put("0000", "000000");
        cancelTypeMap.put("0014", "000002");
        cancelTypeMap.put("0101", "010004");
        cancelTypeMap.put("0201", "020001");
        cancelTypeMap.put("0202", "020006");
        cancelTypeMap.put("0301", "030001");
        cancelTypeMap.put("0302", "030006");
        cancelTypeMap.put("0601", "100001");
        cancelTypeMap.put("0602", "100006");
        cancelTypeMap.put("0701", "110101");
        cancelTypeMap.put("0702", "110106");
        cancelTypeMap.put("0901", "180001");
        cancelTypeMap.put("0902", "180006");
        cancelTypeMap.put("1001", "190001");
        cancelTypeMap.put("1002", "190006");
        cancelTypeMap.put("1101", "200001");
        cancelTypeMap.put("1104", "200312");
    }
}

