/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.confirm;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.payable.confirm.querydrawfin.NoteStatusQuery;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryConfirmNoteImpl
extends AbstractQueryNotePayableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryConfirmNoteImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NEWEBQUERYDRAWFINDTLTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5408\u540c\u786e\u8ba4\u7ed3\u679c", (String)"QueryConfirmNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element QUERYDRAWFINDTLTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBQUERYDRAWFINDTLTRNRQ");
        JDomUtils.addChild((Element)QUERYDRAWFINDTLTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element body = JDomUtils.addChildAttribute((Element)QUERYDRAWFINDTLTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        JDomUtils.addChild((Element)body, (String)"APPLYCODE", (String)"");
        String bankRefKey = ((NotePayableInfo)bankNotePayableRequest.getNotePayableInfoList().get(0)).getBankRefKey();
        if (!StringUtils.isNotEmpty((String)bankRefKey) || !bankRefKey.contains("@")) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5728\u7ebf\u878d\u8d44\u7533\u8bf7\u4f7f\u7528\u6d41\u6c34\u4e3a\u7a7a\u3002", (String)"QueryConfirmNoteImpl1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"CLIENTREF", (String)bankRefKey.split("@")[0]);
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("NEWEBQUERYDRAWFINDTLTRNRS");
        Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        String applyStatus = JDomUtils.getChildText((Element)RSBODY, (String)"APPLYSTATUS");
        String returnReason = JDomUtils.getChildText((Element)RSBODY, (String)"RETURNREASON");
        String applyStatusName = JDomUtils.getChildText((Element)RSBODY, (String)"APPLYSTATUSNAME");
        String[] subCode = new String[]{"YT", "YF"};
        String[] unknownCode = new String[]{"TH"};
        List contentList = RSBODY.getChildren("CONTENT");
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        HashMap notePayableInfoMap = Maps.newHashMapWithExpectedSize((int)notePayableInfos.size());
        for (NotePayableInfo info : notePayableInfos) {
            String bankRefKey = info.getBankRefKey();
            notePayableInfoMap.put(bankRefKey.split("@")[1], info);
        }
        for (Element content : contentList) {
            String billCode = content.getChildText("DRAFTNO");
            String DRAFTRANGE = content.getChildText("DRAFTRANGE");
            String DRAFTSTATUS = content.getChildText("DRAFTSTATUS");
            String billStatus = content.getChildText("CIBDRAFTSTATUS");
            String indx = content.getChildText("INDX");
            NotePayableInfo info = (NotePayableInfo)notePayableInfoMap.get(indx);
            if (info == null) continue;
            info.setBillNo(billCode);
            info.setNoteStatus(DRAFTSTATUS);
            info.setSubRange(DRAFTRANGE);
            info.setStartNo(NoteHandlerHelper.getStartNo(DRAFTRANGE, ","));
            info.setEndNo(NoteHandlerHelper.getEndNo(DRAFTRANGE, ","));
            PaymentState noteState = PaymentState.SUBMITED;
            if (Collections.singletonList(subCode).contains(applyStatus)) {
                noteState = PaymentState.SUBMITED;
            }
            if (Collections.singletonList(unknownCode).contains(applyStatus)) {
                noteState = PaymentState.UNKNOWN;
            }
            StringBuilder sb = new StringBuilder(info.getBankMsg());
            if (noteState != null) {
                info.setStatus(Integer.valueOf(noteState.getId()));
                sb.append(StringUtils.isEmpty((String)applyStatusName) ? "" : "," + applyStatusName);
                sb.append(StringUtils.isEmpty((String)returnReason) ? "" : "," + returnReason);
                info.setBankMsg(sb.toString());
            }
            if (!StringUtils.isEmpty((String)billCode)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)billStatus, (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u767b\u8bb0", (String)"QueryDrawfinDtailParser_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
            BankNotePayableRequest request = new BankNotePayableRequest();
            request.setHeader(bankNotePayableRequest.getHeader());
            request.setNotePayableInfoList(Collections.singletonList(info));
            NoteStatusQuery noteStatusQuery = new NoteStatusQuery();
            EBBankNotePayableResponse ebBankNotePayableResponse = noteStatusQuery.doBiz(request);
            NotePayableInfo notePayableInfo = (NotePayableInfo)ebBankNotePayableResponse.getNotePayableInfos().get(0);
            if (!"TF0302".equals(notePayableInfo.getCirStatus())) continue;
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)billStatus, (String)"");
        }
        return bankNotePayableRequest.getNotePayableInfoList();
    }

    public int getBatchSize() {
        return 10;
    }
}

