/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.register;

import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.BankBusinessConfig;
import kd.ebg.note.banks.cib.dc.services.Common;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteStatusUtil;
import kd.ebg.note.banks.cib.dc.services.newnote.payable.QueryNotePayableImpl;
import kd.ebg.note.banks.cib.dc.services.newnote.payable.register.DownloadFileImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.fileupload.FileServerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.util.NoteStatusUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryRegisterNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRegisterNotePayableImpl.class);

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NEWEBQUERYDRAWFINANCETRNRQ/EBBATCHSTATUSTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u7968\u72b6\u6001", (String)"QueryRegisterNotePayableImpl_17", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        if (BankBusinessConfig.isOnlineRegister() && "AC01".equals(((NotePayableInfo)bankNotePayableRequest.getNotePayableInfoList().get(0)).getDraftType())) {
            NotePayableInfo info = (NotePayableInfo)bankNotePayableRequest.getNotePayableInfoList().get(0);
            String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
            Element cms = CIB_DC_Packer.buildHeadMessage();
            Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
            Element QUERYDRAWFINANCETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBQUERYDRAWFINANCETRNRQ");
            JDomUtils.addChild((Element)QUERYDRAWFINANCETRNRQ, (String)"TRNUID", (String)TRNUID);
            Element body = JDomUtils.addChild((Element)QUERYDRAWFINANCETRNRQ, (String)"RQBODY");
            JDomUtils.addChild((Element)body, (String)"CLIENTREF", (String)info.getBankSerialNo());
            String encoding = RequestContextUtils.getCharset();
            return JDomUtils.root2String((Element)cms, (String)encoding);
        }
        return new QueryNotePayableImpl().pack(bankNotePayableRequest, s);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        if (BankBusinessConfig.isOnlineRegister() && "AC01".equals(((NotePayableInfo)bankNotePayableRequest.getNotePayableInfoList().get(0)).getDraftType())) {
            this.parseQueryPayByOnline(bankNotePayableRequest.getNotePayableInfoList(), rspStr);
            return bankNotePayableRequest.getNotePayableInfoList();
        }
        this.parseQueryPayByCommon(bankNotePayableRequest.getNotePayableInfoList(), rspStr);
        return bankNotePayableRequest.getNotePayableInfoList();
    }

    public int getBatchSize() {
        return 0;
    }

    private void parseQueryPayByCommon(List<NotePayableInfo> notePayableInfos, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBBATCHSTATUSTRNRS = eb1.getChild("NEWEBBIZPROCESSSTSQUERYTRNRS");
        Element STATUS = EBBATCHSTATUSTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)MESSAGE);
            return;
        }
        Element RSBODY = EBBATCHSTATUSTRNRS.getChild("RSBODY");
        List list = RSBODY.getChildren("CONTENT");
        HashMap<String, NotePayableInfo> payNoteMap = new HashMap<String, NotePayableInfo>(5);
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            payNoteMap.put(notePayableInfo.getReserved2(), notePayableInfo);
        }
        for (Element rs : list) {
            String index = rs.getChildText("ISSUERGSTRNO");
            NotePayableInfo info = (NotePayableInfo)payNoteMap.get(index);
            if (info == null) {
                this.logger.info("\u6d41\u6c34{}\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u51fa\u7968\u4fe1\u606f", (Object)index);
                break;
            }
            String rsBillNo = rs.getChildText("DRAFTNO");
            String DRAFTRANGE = rs.getChildText("DRAFTRANGE");
            info.setSubRange(DRAFTRANGE);
            info.setStartNo(NoteHandlerHelper.getStartNo(DRAFTRANGE, ","));
            info.setEndNo(NoteHandlerHelper.getEndNo(DRAFTRANGE, ","));
            String BILLSTATUS = rs.getChildText("DRAFTSTATUS");
            String TRANSFLAG = rs.getChildText("TRANSFLAG");
            String CIBDRAFTSTATUS = rs.getChildText("CIBDRAFTSTATUS");
            info.setCirStatus(TRANSFLAG);
            info.setNoteStatus(NoteStatusUtil.INSTANCE.convert2Bank(CIBDRAFTSTATUS));
            String RSLTMSG = rs.getChildText("RSPREMARK");
            info.setBillNo(rsBillNo);
            info.setNoteStatus(BILLSTATUS);
            this.logger.info("BILLSTATUS:" + BILLSTATUS + ",rsBillNo:" + rsBillNo + ",cirStatus:" + TRANSFLAG);
            String CPEBIZPRCSTS = rs.getChildText("CPEBIZPRCSTS");
            if ("S01".equals(CPEBIZPRCSTS) || "R02".equals(CPEBIZPRCSTS) || "R03".equals(CPEBIZPRCSTS)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
                continue;
            }
            if ("S03".equals(CPEBIZPRCSTS) || "S05".equals(CPEBIZPRCSTS) || "S07".equals(CPEBIZPRCSTS) || "R06".equals(CPEBIZPRCSTS) || "R08".equals(CPEBIZPRCSTS) || "R10".equals(CPEBIZPRCSTS) || "R12".equals(CPEBIZPRCSTS)) {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.FAIL, (String)CPEBIZPRCSTS, (String)RSLTMSG);
                continue;
            }
            if ("S02".equals(CPEBIZPRCSTS) || "S06".equals(CPEBIZPRCSTS) || "R05".equals(CPEBIZPRCSTS) || "R09".equals(CPEBIZPRCSTS)) {
                String stage = "1";
                if ("1".equals(notePayableInfos.get(0).getAutoAccept()) && "1".equals(notePayableInfos.get(0).getAutoReceive())) {
                    stage = "3";
                }
                NoteStatusUtils.parseOldNoteStatus(notePayableInfos, (String)stage);
                continue;
            }
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        }
    }

    private void parseQueryPayByOnline(List<NotePayableInfo> notePayableInfos, String rspStr) {
        NotePayableInfo payableInfo = notePayableInfos.get(0);
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBBATCHSTATUSTRNRS = eb1.getChild("NEWEBQUERYDRAWFINANCETRNRS");
        Element STATUS = EBBATCHSTATUSTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)MESSAGE);
            return;
        }
        Element body = EBBATCHSTATUSTRNRS.getChild("RSBODY");
        String resultCode = JDomUtils.getChildText((Element)body, (String)"RESULTCODE");
        if ("01".equals(resultCode)) {
            String errMessage = JDomUtils.getChildText((Element)body, (String)"ERRMESSAGE");
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)errMessage);
            return;
        }
        if ("02".equals(resultCode)) {
            String errMessage = JDomUtils.getChildText((Element)body, (String)"ERRMESSAGE");
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)resultCode, (String)errMessage);
        } else if ("03".equals(resultCode)) {
            String errMessage = JDomUtils.getChildText((Element)body, (String)"ERRMESSAGE");
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.FAIL, (String)resultCode, (String)errMessage);
        } else if ("04".equals(resultCode)) {
            File file = null;
            try {
                String fileName = JDomUtils.getChildText((Element)body, (String)"FILENAME");
                String fileId = JDomUtils.getChildText((Element)body, (String)"FILEID");
                if ("Y".equals(payableInfo.getIsOnlineBal())) {
                    Element margin_info = JDomUtils.getChildElement((Element)body, (String)"MARGIN_INFO");
                    if (margin_info == null) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5728\u7ebf\u5f00\u7acb\u4fdd\u8bc1\u91d1\uff0c\u94f6\u884c\u8fd4\u56de\u4fdd\u8bc1\u91d1\u4fe1\u606f\u4e3a\u7a7a", (String)"", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                    }
                    Element marginAcctInfo = JDomUtils.getChildElement((Element)margin_info, (String)"MARGIN_ACCT_INFO");
                    if (marginAcctInfo == null) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5728\u7ebf\u5f00\u7acb\u4fdd\u8bc1\u91d1\uff0c\u94f6\u884c\u8fd4\u56de\u4fdd\u8bc1\u91d1\u4fe1\u606f\u4e3a\u7a7a", (String)"", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                    }
                    String marginSerialNum = JDomUtils.getChildText((Element)marginAcctInfo, (String)"MARGIN_SERIAL_NUM");
                    String contractNo = JDomUtils.getChildText((Element)marginAcctInfo, (String)"AGREEMENT_ID");
                    String marginAcc = JDomUtils.getChildText((Element)marginAcctInfo, (String)"MARGIN_ACCT_ID");
                    String marginAccName = JDomUtils.getChildText((Element)marginAcctInfo, (String)"MARGIN_ACCT_NAME");
                    String marginAmt = JDomUtils.getChildText((Element)marginAcctInfo, (String)"MARGIN_AMT");
                    String yearRate = JDomUtils.getChildText((Element)marginAcctInfo, (String)"YEAR_INTREST_RATE");
                    String marginTimeLimit = JDomUtils.getChildText((Element)marginAcctInfo, (String)"MARGIN_TIME_LIMIT");
                    String marginTimeLimitUnit = JDomUtils.getChildText((Element)marginAcctInfo, (String)"MARGIN_TIME_LIMIT_UNIT");
                    for (NotePayableInfo notePayableInfo : notePayableInfos) {
                        notePayableInfo.setBalBizNo(marginSerialNum);
                        notePayableInfo.setBalContractNo(contractNo);
                        notePayableInfo.setBalEac(marginAcc);
                        notePayableInfo.setBalEacName(marginAccName);
                        if (StringUtils.isNotEmpty((String)marginAmt)) {
                            notePayableInfo.setBalAmount(new BigDecimal(marginAmt).setScale(2));
                        }
                        notePayableInfo.setBalRate(yearRate);
                        notePayableInfo.setBalTerm(marginTimeLimit);
                        notePayableInfo.setBalTermUnit(marginTimeLimitUnit);
                    }
                }
                String filePath = "";
                this.logger.info("*******\u6587\u4ef6\u751f\u6210\u6210\u529f\uff0c\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
                filePath = EBContext.getContext().getProxyType() != null ? new DownloadFileImpl().getFileByProxy(fileName, fileId) : new Common().downloadFileFromBank3(fileName, fileId);
                this.logger.info("*******\u4e0b\u8f7d\u6587\u4ef6\u5b8c\u6210:\u6587\u4ef6\u540d\uff1a" + fileName + ";\u6587\u4ef6id=" + fileId + ";\u6587\u4ef6\u8def\u5f84\uff1a" + filePath);
                if (StringUtils.isEmpty((String)filePath)) {
                    this.logger.error("\u878d\u8d44\u7533\u8bf7\u5904\u7406\u7ed3\u679c\u67e5\u8be2\uff1a\u672a\u83b7\u53d6\u5230\u6587\u4ef6");
                    return;
                }
                file = FileCommonUtils.getFileByPath((String)filePath);
                String name = file.getName();
                this.logger.info("\u6587\u4ef6\u540d{}", (Object)name);
                if (!file.exists()) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)resultCode, (String)ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u83b7\u53d6\u6210\u529f\uff0c\u6587\u4ef6\u4e0b\u8f7d\u672a\u5b8c\u6210\u3002", (String)"QueryRegisterNotePayableImpl_11", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                } else {
                    this.logger.info("*******\u4e0a\u4f20\u6587\u4ef6\u81f3\u6587\u4ef6\u670d\u52a1\u5668");
                    String ServerPath = FileServerUtil.uploadFile((String)filePath, (String)fileName);
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)resultCode, (String)ResManager.loadKDString((String)"\u7535\u5b50\u5408\u540c\u751f\u6210\u6210\u529f\uff0c\u8bf7\u786e\u8ba4\u5408\u540c\u3002", (String)"QueryRegisterNotePayableImpl_12", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                    String md5 = Common.getMD5(file);
                    for (NotePayableInfo notePayableInfo : notePayableInfos) {
                        notePayableInfo.setReserved1(fileId);
                        notePayableInfo.setReserved2(fileName);
                        notePayableInfo.setReserved3(ServerPath);
                        notePayableInfo.setReserved4(md5);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u878d\u8d44\u7533\u8bf7\u5904\u7406\u7ed3\u679c\u67e5\u8be2\u89e3\u6790\u62a5\u9519", (Throwable)e);
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            finally {
                if (file != null && !file.delete()) {
                    this.logger.info("\u5904\u7406\u540e\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                }
            }
        }
    }
}

