/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.receivable;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.receivable.pledge.ReceivablePledgeNoteImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryNoteReceivableImpl
extends AbstractQueryNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceivablePledgeNoteImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "EBBATCHSTATUSTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u6279\u91cf\u72b6\u6001\u67e5\u8be2-\u5e94\u6536\u7968\u636e", (String)"QueryNoteReceivableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        String type;
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBBATCHSTATUSTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBBIZPROCESSSTSQUERYTRNRQ");
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBBATCHSTATUSTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBBATCHSTATUSTRNRQ, (String)"RQBODY", (String)"PAGE", (String)"1");
        EBBATCHSTATUSTRNRQ_RQBODY.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ_RQBODY, (String)"CLIENTREF", (String)info.getReserved1());
        switch (bankNoteReceivableRequest.getHeader().getSubBizType()) {
            case "note_endorse": {
                type = "BC07";
                break;
            }
            case "note_discount": {
                type = "BC08";
                break;
            }
            case "note_signin": {
                type = "SD92";
                break;
            }
            case "present_payment": {
                type = "BC13";
                break;
            }
            case "pledge_note": {
                type = "BC11";
                break;
            }
            case "remove_pledge": {
                type = "BC12";
                break;
            }
            case "note_cancle": {
                type = "SD91";
                break;
            }
            default: {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5f53\u524d\u5b50\u4e1a\u52a1\u7c7b\u578b\u67e5\u8be2%s", (String)"QueryNoteReceivableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), bankNoteReceivableRequest.getHeader().getSubBizType()));
            }
        }
        JDomUtils.addChild((Element)EBBATCHSTATUSTRNRQ_RQBODY, (String)"BIZTYPE", (String)type);
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rspStr) {
        HashMap<String, String> unknow = new HashMap<String, String>(){
            {
                this.put("3000", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25-\u8fbe\u5230\u670d\u52a1\u6700\u5927\u9650\u5236", (String)"QueryNoteReceivableImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                this.put("4000", ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u9519\u8bef", (String)"QueryNoteReceivableImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
            }
        };
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBBATCHSTATUSTRNRS = eb1.getChild("NEWEBBIZPROCESSSTSQUERYTRNRS");
        Element STATUS = EBBATCHSTATUSTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)MESSAGE);
            return receivableInfos;
        }
        Element RSBODY = EBBATCHSTATUSTRNRS.getChild("RSBODY");
        List list = RSBODY.getChildren("CONTENT");
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        for (Element rs : list) {
            String rsBillNo = rs.getChildText("DRAFTNO");
            String DRAFTRANGE = rs.getChildText("DRAFTRANGE");
            NoteHandlerHelper.convertReturnSubBillRng(info, DRAFTRANGE, ",");
            String BILLSTATUS = rs.getChildText("DRAFTSTATUS");
            String TRANSFLAG = rs.getChildText("TRANSFLAG");
            info.setCirStatus(TRANSFLAG);
            info.setKeepFlag(TRANSFLAG);
            String RSLTMSG = rs.getChildText("BIZAPPPRCMSG");
            info.setBillNo(rsBillNo);
            info.setNoteStatus(BILLSTATUS);
            this.logger.info("BILLSTATUS:" + BILLSTATUS + ",rsBillNo:" + rsBillNo);
            String CPEBIZPRCSTS = rs.getChildText("CPEBIZPRCSTS");
            String subBizType = bankNoteReceivableRequest.getHeader().getSubBizType();
            if ("note_cancle".equals(subBizType)) {
                this.parseCancle(receivableInfos, CPEBIZPRCSTS, RSLTMSG);
                continue;
            }
            if ("note_endorse".equals(subBizType)) {
                this.parseEndOrSe(receivableInfos, CPEBIZPRCSTS, RSLTMSG);
                continue;
            }
            if ("pledge_note".equals(subBizType)) {
                this.parsePledge(receivableInfos, CPEBIZPRCSTS, RSLTMSG);
                continue;
            }
            if ("note_discount".equals(subBizType)) {
                this.parseNoteDiscount(receivableInfos, CPEBIZPRCSTS, RSLTMSG);
                continue;
            }
            this.parseOther(receivableInfos, CPEBIZPRCSTS, RSLTMSG);
        }
        return receivableInfos;
    }

    private void parseEndOrSe(List<NoteReceivableInfo> receivableInfos, String CPEBIZPRCSTS, String RSLTMSG) {
        NoteReceivableInfo info = receivableInfos.get(0);
        if ("S01".equals(CPEBIZPRCSTS) || "R02".equals(CPEBIZPRCSTS) || "R03".equals(CPEBIZPRCSTS) || "S02".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S03".equals(CPEBIZPRCSTS) || "S05".equals(CPEBIZPRCSTS) || "S07".equals(CPEBIZPRCSTS) || "R06".equals(CPEBIZPRCSTS) || "R08".equals(CPEBIZPRCSTS) || "R10".equals(CPEBIZPRCSTS) || "R12".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.FAIL, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S04".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        }
    }

    private void parsePledge(List<NoteReceivableInfo> receivableInfos, String CPEBIZPRCSTS, String RSLTMSG) {
        NoteReceivableInfo info = receivableInfos.get(0);
        if ("S01".equals(CPEBIZPRCSTS) || "S02".equals(CPEBIZPRCSTS) || "R02".equals(CPEBIZPRCSTS) || "R03".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S03".equals(CPEBIZPRCSTS) || "S05".equals(CPEBIZPRCSTS) || "S07".equals(CPEBIZPRCSTS) || "R06".equals(CPEBIZPRCSTS) || "R08".equals(CPEBIZPRCSTS) || "R10".equals(CPEBIZPRCSTS) || "R12".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S04".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        }
    }

    private void parseNoteDiscount(List<NoteReceivableInfo> receivableInfos, String CPEBIZPRCSTS, String RSLTMSG) {
        NoteReceivableInfo info = receivableInfos.get(0);
        if ("S01".equals(CPEBIZPRCSTS) || "S02".equals(CPEBIZPRCSTS) || "S04".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S03".equals(CPEBIZPRCSTS) || "S05".equals(CPEBIZPRCSTS) || "S07".equals(CPEBIZPRCSTS) || "S09".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S06".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        }
    }

    private void parseCancle(List<NoteReceivableInfo> receivableInfos, String CPEBIZPRCSTS, String RSLTMSG) {
        NoteReceivableInfo info = receivableInfos.get(0);
        if ("S01".equals(CPEBIZPRCSTS) || "R02".equals(CPEBIZPRCSTS) || "R03".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S03".equals(CPEBIZPRCSTS) || "S05".equals(CPEBIZPRCSTS) || "S07".equals(CPEBIZPRCSTS) || "R06".equals(CPEBIZPRCSTS) || "R08".equals(CPEBIZPRCSTS) || "R10".equals(CPEBIZPRCSTS) || "R12".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.FAIL, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S02".equals(CPEBIZPRCSTS) || "S06".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        }
    }

    private void parseOther(List<NoteReceivableInfo> receivableInfos, String CPEBIZPRCSTS, String RSLTMSG) {
        NoteReceivableInfo info = receivableInfos.get(0);
        if ("S01".equals(CPEBIZPRCSTS) || "S02".equals(CPEBIZPRCSTS) || "R02".equals(CPEBIZPRCSTS) || "R03".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S03".equals(CPEBIZPRCSTS) || "S05".equals(CPEBIZPRCSTS) || "S07".equals(CPEBIZPRCSTS) || "R06".equals(CPEBIZPRCSTS) || "R08".equals(CPEBIZPRCSTS) || "R10".equals(CPEBIZPRCSTS) || "R12".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.FAIL, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else if ("S04".equals(CPEBIZPRCSTS) || "S06".equals(CPEBIZPRCSTS) || "R05".equals(CPEBIZPRCSTS) || "R07".equals(CPEBIZPRCSTS) || "R09".equals(CPEBIZPRCSTS)) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        } else {
            EBGNoteReceivableUtils.setPaymentState(receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)CPEBIZPRCSTS, (String)RSLTMSG);
        }
    }

    public int getBatchSize() {
        return 0;
    }
}

