/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.receivable.payment;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteStatusUtil;
import kd.ebg.note.banks.cib.dc.services.newnote.receivable.QueryNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivablePaymentNoteImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceivablePaymentNoteImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NEWEBCUEPAYTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u63d0\u793a\u4ed8\u6b3e", (String)"ReceivablePaymentNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBCUEPAYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBCUEPAYTRNRQ");
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBCUEPAYTRNRQ_RQBODY = JDomUtils.addChild((Element)EBCUEPAYTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            NoteReceivableInfo infoChecked = NoteStatusUtil.INSTANCE.queryOperableNoteDetails(info, "BC13");
            if (StringUtils.isEmpty((String)infoChecked.getReserved4())) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u62a5\u9519\uff0c%s\u65e0\u6cd5\u63d0\u793a\u4ed8\u6b3e\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001", (String)"ReceivablePaymentNoteImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), infoChecked.getBillNo()));
            }
            noteReceivableInfo.setReserved1(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBCUEPAYTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTNO", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTRANGE", (String)NoteHandlerHelper.getFixSubBillRng(infoChecked));
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTAMT", (String)infoChecked.getReserved4());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"SETTLEAMT", (String)infoChecked.getReserved4());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"SETTLEMODE", (String)"ST01");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"CLEARTYPE", (String)"CT01");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"SETTLEDATE", (String)LocalDateUtil.formatDate((LocalDate)noteReceivableInfo.getDueDate()));
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(rsp);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return receivableInfos;
        }
        Element EBDISCNTTRNRS = eb1.getChild("NEWEBCUEPAYTRNRS");
        Element STATUS = EBDISCNTTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)MESSAGE);
        }
        return receivableInfos;
    }
}

