/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.simulator.service.util;

import java.math.BigDecimal;
import java.util.List;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.simulator.business.BusinessDealUtil;
import kd.ebg.note.common.model.NotePayableInfo;

public class NotePayableUtil {
    public static void setRegiset(List<NotePayableInfo> notePayableInfos) {
        NotePayableInfo info = notePayableInfos.get(0);
        info.setBankRefKey(info.getBankBatchSeqId());
        if (info.getBankStatus().contains("0") || info.getBankStatus().contains("1") || info.getBankStatus().contains("2") || info.getBankStatus().contains("3")) {
            if (StringUtils.isEmpty((String)info.getBillNo())) {
                info.setBillNo(Sequence.gen18Sequence());
            }
            if (StringUtils.isEmpty((String)info.getStartNo()) || StringUtils.isEmpty((String)info.getEndNo())) {
                long amount = info.getAmount().multiply(new BigDecimal("100")).longValue();
                info.setStartNo("1");
                info.setEndNo(amount + "");
            }
            if (info.getBankStatus().contains("0")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS01");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0301");
                }
                BusinessDealUtil.doInsertHoldPayablePayee(info);
            } else if (info.getBankStatus().contains("1")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS02");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0302");
                }
                BusinessDealUtil.doInsertHoldPayable(info);
                BusinessDealUtil.doInsertReplyPayable(info);
            } else if (info.getBankStatus().contains("2")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS02");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0101");
                }
                BusinessDealUtil.doInsertHoldPayable(info);
            } else if (info.getBankStatus().contains("3")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS01");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0101");
                }
                BusinessDealUtil.doInsertHoldPayable(info);
            }
        }
    }

    public static void setPayable(List<NotePayableInfo> notePayableInfos) {
        NotePayableInfo info = notePayableInfos.get(0);
        String subBizType = info.getSubBizType();
        if (StringUtils.isEmpty((String)info.getStartNo()) || StringUtils.isEmpty((String)info.getEndNo())) {
            if ("0".equals(info.getGrdBag())) {
                info.setStartNo("0");
                info.setEndNo("0");
                info.setSubRange("0");
            } else {
                long amount = info.getAmount().multiply(new BigDecimal("100")).longValue();
                info.setStartNo("1");
                info.setEndNo(amount + "");
            }
        }
        if ("remit_register".equals(subBizType)) {
            if (info.getBankStatus().contains("0")) {
                if (StringUtils.isEmpty((String)info.getBillNo())) {
                    info.setBillNo(Sequence.gen18Sequence());
                }
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS01");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0301");
                }
                BusinessDealUtil.doInsertHoldPayable(info);
            } else if (info.getBankStatus().contains("1")) {
                if (StringUtils.isEmpty((String)info.getBillNo())) {
                    info.setBillNo(Sequence.gen18Sequence());
                }
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS01");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0301");
                }
            }
        } else if ("remit_revocation".equals(subBizType)) {
            if (info.getBankStatus().contains("0")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS05");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0501");
                }
                BusinessDealUtil.dodeleteHoldPayable(info);
            } else if (info.getBankStatus().contains("1")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS02");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0101");
                }
            }
        } else if ("remit_accept".equals(subBizType)) {
            if (info.getBankStatus().contains("0")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS02");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0101");
                }
                BusinessDealUtil.dodeleteHoldPayable(info);
                BusinessDealUtil.doInsertHoldPayable(info);
            } else if (info.getBankStatus().contains("1")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS01");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0302");
                }
                if ("AC02".equals(info.getDraftType())) {
                    info.setBankRefKey(info.getBankBatchSeqId());
                    BusinessDealUtil.doInsertReplyAccept(info);
                }
            }
        } else if ("remit_receive".equals(subBizType)) {
            if (info.getBankStatus().contains("0")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS01");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0301");
                }
                BusinessDealUtil.dodeleteHoldPayable(info);
                BusinessDealUtil.doInsertHoldPayablePayee(info);
            } else if (info.getBankStatus().contains("1")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS02");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0302");
                }
                info.setBankRefKey(info.getBankBatchSeqId());
                BusinessDealUtil.doInsertReplyPayable(info);
            }
        } else if ("remit_cancle".equals(subBizType)) {
            if ("02".equals(info.getOperationCode())) {
                if (info.getBankStatus().contains("0")) {
                    if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                        info.setNoteStatus("CS01");
                    }
                    if (StringUtils.isEmpty((String)info.getCirStatus())) {
                        info.setCirStatus("TF0101");
                    }
                    BusinessDealUtil.dodeleteReplyAccept(info);
                }
            } else if (info.getBankStatus().contains("0")) {
                if (StringUtils.isEmpty((String)info.getNoteStatus())) {
                    info.setNoteStatus("CS02");
                }
                if (StringUtils.isEmpty((String)info.getCirStatus())) {
                    info.setCirStatus("TF0301");
                }
                BusinessDealUtil.dodeleteReply(info);
            }
        } else if ("nonnegotiable_cancle".equals(subBizType)) {
            info.setTransferFlag("EM00");
        }
    }
}

