/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.payable.register;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.payable.register.QueryRegisterImpl;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.FileInfoNode;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.NoteFileUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class RegisterImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public String getFirstPageTag() {
        return "0";
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P1CPEN002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u7533\u8bf7", (String)"RegisterImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        String message;
        LoginUtils.login();
        NotePayableInfo[] notePayableInfos = bankNotePayableRequest.getNotePayableInfosAsArray();
        String datestr = DateUtil.formatDate((Date)new Date());
        String fileName = "05" + datestr + "4" + notePayableInfos[0].getBankBatchSeqId() + ".txt";
        StringBuilder sBuffer = new StringBuilder();
        if ("AC02".equals(notePayableInfos[0].getDraftType())) {
            fileName = "05" + datestr + "1" + notePayableInfos[0].getBankBatchSeqId() + ".txt";
            String title = PropertiesConstantsUtils.getValue((String)"ccbccipRegisternew");
            sBuffer.append(title);
            for (int i = 0; i < notePayableInfos.length; ++i) {
                sBuffer.append("\r\n");
                NotePayableInfo info = notePayableInfos[i];
                sBuffer.append(i + 1).append('|');
                sBuffer.append("AC02").append('|');
                sBuffer.append(info.getAmount()).append('|');
                sBuffer.append(LocalDateUtil.formatDate((LocalDate)notePayableInfos[i].getBookingDate())).append('|');
                sBuffer.append(LocalDateUtil.formatDate((LocalDate)notePayableInfos[i].getDueDate())).append('|');
                sBuffer.append(info.getTransferFlag()).append('|');
                String grdBag = info.getGrdBag();
                if (StringUtils.isEmpty((String)grdBag)) {
                    sBuffer.append("0").append('|');
                } else {
                    sBuffer.append(grdBag).append('|');
                }
                sBuffer.append(info.getDrawerAccName()).append('|');
                sBuffer.append(info.getDrawerAccNo()).append('|');
                sBuffer.append(info.getDrawerBankCnaps()).append('|');
                sBuffer.append(info.getDrawerBankName()).append('|');
                sBuffer.append(PropertiesConstantsUtils.getValue((String)"ccb_remark")).append('|');
                sBuffer.append(info.getExplanation()).append('|');
                sBuffer.append(info.getAcceptorAccName()).append('|');
                sBuffer.append(info.getAcceptorAccNo()).append('|');
                sBuffer.append(info.getAcceptorBankCnaps()).append('|');
                sBuffer.append(info.getAcceptorBankName()).append('|');
                sBuffer.append(info.getPayeeAccName()).append('|');
                sBuffer.append(info.getPayeeAccNo()).append('|');
                sBuffer.append(info.getPayeeBankCnaps()).append('|');
                sBuffer.append(info.getPayeeBankName()).append('|');
                sBuffer.append("0001").append('|');
                sBuffer.append("").append('|');
                sBuffer.append(info.getBankBatchSeqId()).append('|');
                sBuffer.append("");
                info.setAutoAccept("1");
                info.setAutoReceive("0");
            }
        } else {
            sBuffer.append(PropertiesConstantsUtils.getValue((String)"ccb_register_01"));
            for (int i = 0; i < notePayableInfos.length; ++i) {
                sBuffer.append("\r\n");
                NotePayableInfo info = notePayableInfos[i];
                sBuffer.append(i + 1).append('|');
                sBuffer.append(info.getBillNo()).append('|');
                sBuffer.append(LocalDateUtil.formatDate((LocalDate)notePayableInfos[i].getBookingDate())).append('|');
                sBuffer.append(LocalDateUtil.formatDate((LocalDate)notePayableInfos[i].getDueDate())).append('|');
                sBuffer.append("1").append('|');
                String grdBag = info.getGrdBag();
                if (StringUtils.isEmpty((String)grdBag)) {
                    sBuffer.append("0").append('|');
                } else {
                    sBuffer.append(grdBag).append('|');
                }
                sBuffer.append(info.getTransferFlag()).append('|');
                sBuffer.append(info.getExplanation()).append('|');
                sBuffer.append(info.getBankBatchSeqId()).append('|');
                sBuffer.append("").append('|');
                info.setAutoAccept("1");
                info.setAutoReceive("0");
            }
        }
        String fileContent = sBuffer.toString();
        NoteFileUtils fileUtils = new NoteFileUtils();
        FileInfoNode fileInfoNode = fileUtils.getFileInfoNodes(fileContent, fileName);
        try {
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileInfoNode.getFileName());
            message = fileUtils.uploadFile(fileInfoNode);
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.logger.info(fileInfoNode.getFileContent());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (String)"RegisterImpl_4", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]));
        }
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEN020", Sequence.genSequence());
        if ("AC02".equals(notePayableInfos[0].getDraftType())) {
            headr = CommonPacker.packCommonHeader("P1CPEN021", Sequence.genSequence());
        }
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        Element file = JDomExtUtils.addChild((Element)common, (String)"FILE_LIST_PACK");
        JDomExtUtils.addChildCDData(file, "FILE_NUM", "1");
        Element fileInfo = JDomExtUtils.addChild((Element)file, (String)"FILE_INFO");
        JDomExtUtils.addChildCDData(fileInfo, "FILE_NAME", message);
        JDomExtUtils.addChildCDData(fileInfo, "Msg_Smy", fileInfoNode.getMd5());
        if ("AC01".equals(notePayableInfos[0].getDraftType())) {
            JDomExtUtils.addChildCDData(common, "Bl_Rmtr_Unn_Id_No", "");
            JDomExtUtils.addChildCDData(common, "Bl_Prtc_SgnSl_MtdCd", "PS01");
            JDomExtUtils.addChildCDData(common, "Bl_Prtc_Elc_Sgn", "");
            JDomExtUtils.addChildCDData(common, "Txn_Tdnum", notePayableInfos.length + "");
            JDomExtUtils.addChildCDData(common, "Bl_Acpt_Agrm_ID_Inf", notePayableInfos[0].getContractNo());
            JDomExtUtils.addChildCDData(common, "MD5_Val", fileInfoNode.getMd5());
        } else {
            JDomExtUtils.addChildCDData(common, "Btch_Txn_Tp", "0001");
            JDomExtUtils.addChildCDData(common, "Txn_Tdnum", notePayableInfos.length + "");
            JDomExtUtils.addChildCDData(common, "ExgBill_Plc_Bl_CtCd", notePayableInfos[0].getDraftType());
            JDomExtUtils.addChildCDData(common, "Bl_Rmtr_Unn_Id_No", "");
            JDomExtUtils.addChildCDData(common, "Bl_Prtc_SgnSl_MtdCd", "PS01");
            JDomExtUtils.addChildCDData(common, "Bl_Prtc_Elc_Sgn", "");
            JDomExtUtils.addChildCDData(common, "MD5_Val", fileInfoNode.getMd5());
        }
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        CCBHCBankResponse rsp = CommonParser.getFrontResponse(rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"RegisterImpl_5", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            String BkListNo1 = response.getChildText("Btch_No");
            EBGNotePayableUtils.setBatchNo((List)notePayableInfos, (String)BkListNo1);
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)bankResp.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"%s\u63d0\u4ea4\u94f6\u884c\u6210\u529f\u3002", (String)"RegisterImpl_6", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseMessage()));
        }
        return notePayableInfos;
    }
}

