/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.ccip.service.news.receivable.discount;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.LoginUtils;
import kd.ebg.note.banks.ccb.ccip.service.news.receivable.ParserUtil;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CCBHCBankResponse;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonPacker;
import kd.ebg.note.banks.ccb.ccip.service.note.util.CommonParser;
import kd.ebg.note.banks.ccb.ccip.service.note.util.JDomExtUtils;
import kd.ebg.note.banks.ccb.ccip.service.note.util.PackerUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryDiscountImpl
extends AbstractQueryNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryDiscountImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        LoginUtils.login();
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CPEQ518", Sequence.genSequence(), "", s);
        Element common = PackerUtil.packComEntity(Sequence.genSequence(), "", "0", "200");
        JDomUtils.addChild((Element)body, (Element)common);
        root.addContent((Content)headr);
        JDomExtUtils.addChildCDData(common, "ExgBill_Plc_Bl_CtCd", receivableInfos[0].getDraftType());
        JDomExtUtils.addChildCDData(common, "Btch_No", receivableInfos[0].getObssid());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        CCBHCBankResponse rsp1 = CommonParser.getFrontResponse(rsp);
        if (!rsp1.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%1$s %2$s\u3002", (String)"QueryDiscountImpl_0", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp1.getResponseCode(), rsp1.getResponseMessage()));
        }
        rsp = rsp1.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rsp);
        if (!bankResp.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            Element root = JDomExtUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
            Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
            Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
            List lists = response.getChildren("Rslt_GRP");
            for (NoteReceivableInfo info : receivableInfos) {
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"Bill_No");
                    String Txn_SN = JDomUtils.getChildTextTrim((Element)list, (String)"Txn_SN");
                    String TxnAmt = JDomUtils.getChildTextTrim((Element)list, (String)"TxnAmt");
                    String SignToAcpt_Psn_AccNo = JDomUtils.getChildTextTrim((Element)list, (String)"SignToAcpt_Psn_AccNo");
                    BigDecimal decimalTxnAmt = new BigDecimal(TxnAmt);
                    if (!BkListNo1.equals(info.getBillNo()) || !info.getBankSerialNo().equals(Txn_SN) || info.getAmount().compareTo(decimalTxnAmt) != 0 || !info.getPayeeAccNo().equals(SignToAcpt_Psn_AccNo)) continue;
                    ParserUtil.parseData4One(info, list);
                }
            }
        }
        return receivableInfos;
    }

    public int getBatchSize() {
        return 0;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        CCBHCBankResponse rsp = CommonParser.getFrontResponse(rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\uff0c%1$s %2$s\u3002", (String)"AcceptImpl_2", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%1$s %2$s\u3002", (String)"DetailImpl_1", (String)"ebg-note-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element response = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String TOTAL_PAGE = response.getChildTextTrim("TOTAL_PAGE");
        int total_page = Integer.parseInt(TOTAL_PAGE);
        int page = Integer.parseInt(pageTag);
        return page - 1 >= total_page;
    }
}

