/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.codeless.payable;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryPayableStatusImpl
extends AbstractQueryNotePayableImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayableStatusImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0697";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u4ed8\u540c\u6b65", (String)"QueryPayableStatusImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            List notePayableInfoList = bankNotePayableRequest.getNotePayableInfoList();
            NotePayableInfo info = (NotePayableInfo)notePayableInfoList.get(0);
            String token = "test".equals(EBContext.getContext().getBankLoginID()) ? "testToken" : la.getToken();
            String type = "";
            if (info.getSubBizType().equals("remit_register")) {
                type = "001";
            } else if (info.getSubBizType().equals("remit_accept")) {
                type = "002";
            } else if (info.getSubBizType().equals("remit_receive")) {
                type = "003";
            } else if (info.getSubBizType().equals("remit_cancle")) {
                type = "032";
            } else if (info.getSubBizType().equals("remit_revocation")) {
                type = "004";
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u672a\u5b9e\u73b0\u7684\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u8f93\u5165\u6b63\u786e\u3002", (String)"QueryPayableStatusImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            Element root = Packer.getHeader(token, this.getBizCode());
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0697-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0697-rq");
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)info.getDrawerAccNo());
            JDomUtils.addChild((Element)rq, (String)"msgseq", (String)info.getBankRefKey());
            JDomUtils.addChild((Element)rq, (String)"transtype", (String)type);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfoList = request.getNotePayableInfoList();
        NotePayableInfo notePayableInfo = (NotePayableInfo)notePayableInfoList.get(0);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0697-rs");
        if (trn == null) {
            Element b2eerror = trans.getChild("trn-b2eerror-rs");
            Element status = b2eerror.getChild("status");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u72b6\u6001\u65f6\u94f6\u884c\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"QueryPayableStatusImpl_2", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
        }
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u72b6\u6001\u65f6\u94f6\u884c\u8fd4\u56de\u5916\u5c42\u72b6\u6001\u7801\u9519\u8bef\u3002", (String)"QueryPayableStatusImpl_3", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
        }
        List list = trn.getChildren("b2e0697-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String duedate;
            String date;
            Element rs = (Element)list.get(i);
            List inner_status = rs.getChildren("status");
            String another_rspcod = ((Element)inner_status.get(0)).getChildTextTrim("rspcod");
            if (!"B001".equals(another_rspcod) && !"B054".equals(another_rspcod)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7968\u636e\u72b6\u6001\u65f6\u94f6\u884c\u8fd4\u56de\u5185\u5c42\u72b6\u6001\u7801\u9519\u8bef\u3002", (String)"QueryPayableStatusImpl_4", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            String noteStatus = ((Element)inner_status.get(1)).getText();
            if ("A".equals(noteStatus)) {
                noteStatus = "CS03";
            }
            notePayableInfo.setNoteStatus(noteStatus);
            String blcrclsts = rs.getChildTextTrim("blcrclsts");
            logger.info("\u83b7\u53d6\u5230\u94f6\u884c\u8fd4\u56de\u7684\u6d41\u901a\u6807\u8bc6===" + blcrclsts);
            if (StringUtils.isNotEmpty((String)blcrclsts)) {
                notePayableInfo.setCirStatus(blcrclsts);
            }
            if ("TF0302".equals(blcrclsts)) {
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u7968\u636e\u5df2\u9501\u5b9a\uff0c\u8bf7\u7b7e\u6536\u540e\u518d\u540c\u6b65\u7ed3\u679c", (String)"QueryPayableStatusImpl_5", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            String drafttype = rs.getChildTextTrim("drafttype");
            notePayableInfo.setDraftType(drafttype);
            String draftno = rs.getChildTextTrim("draftno");
            notePayableInfo.setBillNo(draftno);
            String amount = rs.getChildTextTrim("amount");
            if (StringUtils.isNotEmpty((String)amount)) {
                notePayableInfo.setAmount(new BigDecimal(amount));
            }
            if (StringUtils.isNotEmpty((String)(date = rs.getChildTextTrim("date")))) {
                notePayableInfo.setBookingDate(LocalDateUtil.parserDate((String)date));
            }
            if (StringUtils.isNotEmpty((String)(duedate = rs.getChildTextTrim("duedate")))) {
                notePayableInfo.setDueDate(LocalDateUtil.parserDate((String)duedate));
            }
            String transferflg = rs.getChildTextTrim("transferflg");
            notePayableInfo.setTransferFlag(transferflg);
            String memo = rs.getChildTextTrim("memo");
            notePayableInfo.setExplanation(memo);
            String scbintvl = rs.getChildTextTrim("scbintvl");
            notePayableInfo.setSubRange(scbintvl);
        }
        return notePayableInfoList;
    }

    public int getBatchSize() {
        return 0;
    }
}

