/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.codeless.receivable.discount;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.Parser;
import kd.ebg.note.banks.boc.net.service.codeless.errorCode.CodeUtil;
import kd.ebg.note.banks.boc.net.service.codeless.receivable.QueryReceiveImpl;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceiveImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0694";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0", (String)"DiscountImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNoteReceivableRequest request, String s) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = "test".equals(EBContext.getContext().getBankLoginID()) ? "testToken" : la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)this.getBizCode());
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0694-rq");
            JDomUtils.addChild((Element)trn, (String)"ceitinfo");
            BankAcnt acnt = request.getAcnt();
            for (int i = 0; i < noteReceivableInfos.size(); ++i) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0694-rq");
                Element account = JDomUtils.addChild((Element)rq, (String)"account");
                JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
                JDomUtils.addChild((Element)rq, (String)"draftno", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getBillNo());
                String subRange = ((NoteReceivableInfo)noteReceivableInfos.get(i)).getSubRange();
                if (StringUtils.isEmpty((String)subRange)) {
                    subRange = "0";
                }
                JDomUtils.addChild((Element)rq, (String)"scbintvl", (String)subRange);
                JDomUtils.addChild((Element)rq, (String)"rdstyp", (String)"RM00");
                if (((NoteReceivableInfo)noteReceivableInfos.get(i)).getDisCountRate() == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DiscountImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
                }
                BigDecimal b1 = new BigDecimal(((NoteReceivableInfo)noteReceivableInfos.get(i)).getDisCountRate());
                BigDecimal b2 = b1.divide(new BigDecimal(100), 6, 4);
                JDomUtils.addChild((Element)rq, (String)"rdsrat", (String)b2.toString());
                JDomUtils.addChild((Element)rq, (String)"bookdate", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                String payeeBankName = ((NoteReceivableInfo)noteReceivableInfos.get(i)).getPayeeBankName();
                if ("1".equals(((NoteReceivableInfo)noteReceivableInfos.get(i)).getIsPayeeSameBank())) {
                    JDomUtils.addChild((Element)rq, (String)"onlflg", (String)"ST02");
                } else {
                    JDomUtils.addChild((Element)rq, (String)"onlflg", (String)"ST01");
                }
                JDomUtils.addChild((Element)rq, (String)"memo", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getExplanation());
                JDomUtils.addChild((Element)rq, (String)"ratscl", (String)("0".equals(((NoteReceivableInfo)noteReceivableInfos.get(i)).getIncreaseRate()) ? "" : ((NoteReceivableInfo)noteReceivableInfos.get(i)).getIncreaseRate()));
                Element entry = JDomUtils.addChild((Element)rq, (String)"entry");
                JDomUtils.addChild((Element)entry, (String)"toibkn", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getAcceptorBankCnaps());
                JDomUtils.addChild((Element)entry, (String)"actacn", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getAcceptorAccNo());
                JDomUtils.addChild((Element)entry, (String)"toname", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getAcceptorAccName());
                Element inman = JDomUtils.addChild((Element)rq, (String)"inman");
                JDomUtils.addChild((Element)inman, (String)"inibkn", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getPayeeBankCnaps());
                String sameBank = SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)payeeBankName);
                if (sameBank.equals("1")) {
                    JDomUtils.addChild((Element)inman, (String)"inactn", (String)"0");
                } else {
                    JDomUtils.addChild((Element)inman, (String)"inactn", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getPayeeAccNo());
                }
                JDomUtils.addChild((Element)inman, (String)"incnam", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getPayeeAccName());
                String bustyp = "2";
                if ("3".equals(((NoteReceivableInfo)noteReceivableInfos.get(i)).getDiscountType())) {
                    bustyp = "1";
                }
                JDomUtils.addChild((Element)rq, (String)"payinmode", (String)bustyp);
                JDomUtils.addChild((Element)rq, (String)"discountamt", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getAmount().toString());
                JDomUtils.addChild((Element)rq, (String)"transfermark", (String)((NoteReceivableInfo)noteReceivableInfos.get(i)).getTransferFlag());
                String sequence = Sequence.genSequence();
                JDomUtils.addChild((Element)rq, (String)"insid", (String)sequence);
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0694-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (CodeUtil.validateOuterCode("b2e0694", rspcod)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)rspcod, (String)rspmsg);
        } else if (!"B001".equals(rspcod) && !"B054".equals(rspcod)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0694-rs");
            int size = list.size();
            block0: for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                Element anotherStatus = rs.getChild("status");
                String another_rspcod = anotherStatus.getChildTextTrim("rspcod");
                String another_rspmsg = anotherStatus.getChildTextTrim("rspmsg");
                String obssid = rs.getChildTextTrim("obssid");
                String draftno = rs.getChildTextTrim("draftno");
                for (NoteReceivableInfo info : noteReceivableInfos) {
                    if (!draftno.equals(info.getBillNo())) continue;
                    info.setObssid(obssid);
                    info.setBankRefKey(obssid);
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    if (StringUtils.isEmpty((String)obssid) && ("B5002".equals(another_rspcod) || "B5012".equals(another_rspcod))) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    if (CodeUtil.validateInnerCode("code", another_rspcod)) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                    continue block0;
                }
            }
        }
        return noteReceivableInfos;
    }
}

