/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.note.receivable.pledge;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.Parser;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.banks.boc.net.service.note.receivable.pledge.QueryPledgeNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PledgeNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledgeNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0285";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u7968\u8d28\u62bc(b2e0285)", (String)"PledgeNoteReceivableImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0285");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0285-rq");
            if (noteReceivableInfos.size() > 1) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5355\u6b21\u8bf7\u6c42\u4e0d\u80fd\u8d85\u8fc71\u7b14\u3002", (String)"PledgeNoteReceivableImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]));
            }
            NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0285-rq");
            Element account = JDomUtils.addChild((Element)rq, (String)"account");
            JDomUtils.addChild((Element)account, (String)"ibknum", (String)"");
            JDomUtils.addChild((Element)account, (String)"actacn", (String)request.getAcnt().getAccNo());
            JDomUtils.addChild((Element)rq, (String)"draftno", (String)info.getBillNo());
            Element endorseinfo = JDomUtils.addChild((Element)rq, (String)"pawninfo");
            JDomUtils.addChild((Element)endorseinfo, (String)"cnaps", (String)info.getPayeeBankCnaps());
            JDomUtils.addChild((Element)endorseinfo, (String)"actacn", (String)info.getPayeeAccNo());
            JDomUtils.addChild((Element)endorseinfo, (String)"actnam", (String)info.getPayeeAccName());
            JDomUtils.addChild((Element)rq, (String)"transferflg", (String)info.getTransferFlag());
            String sequence = Sequence.genSequence();
            JDomUtils.addChild((Element)rq, (String)"memo", (String)sequence);
            info.setSequence(sequence);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0285-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rspcod, (String)rspmsg);
        } else {
            List list = trn.getChildren("b2e0285-rs");
            int size = list.size();
            block0: for (int i = 0; i < size; ++i) {
                Element rs = (Element)list.get(i);
                Element anotherStatus = rs.getChild("status");
                String another_rspcod = anotherStatus.getChildTextTrim("rspcod");
                String another_rspmsg = anotherStatus.getChildTextTrim("rspmsg");
                if ("B053".equals(another_rspcod)) {
                    EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)another_rspcod, (String)another_rspmsg);
                    continue;
                }
                String obssid = rs.getChildTextTrim("obssid");
                ((NoteReceivableInfo)noteReceivableInfos.get(0)).setObssid(obssid);
                ((NoteReceivableInfo)noteReceivableInfos.get(0)).setBankRefKey(obssid);
                String draftno = rs.getChildTextTrim("draftno");
                this.logger.info("\u5f53\u524d\u8d28\u62bc\u8fd4\u56de\u7968\u636e\u53f7\u7801\uff1a{}", (Object)draftno);
                for (NoteReceivableInfo noteReceivableInfo : noteReceivableInfos) {
                    this.logger.info("\u904d\u5386\u5e94\u6536\u7968\u636e\u5bf9\u8c61\u7684\u7968\u636e\u53f7\u7801:{}", (Object)noteReceivableInfo.getBillNo());
                    if (!draftno.equals(noteReceivableInfo.getBillNo())) continue;
                    if ("B001".equals(another_rspcod) || "B266".equals(another_rspcod)) {
                        EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)another_rspcod, (String)another_rspmsg);
                        continue block0;
                    }
                    EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)another_rspcod, (String)another_rspmsg);
                    continue block0;
                }
            }
        }
        return noteReceivableInfos;
    }
}

