/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.detail;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.NoteReplyNode;
import kd.ebg.note.banks.abc.dc.service.note.detail.NoteInfoImpl;
import kd.ebg.note.banks.abc.dc.service.note.detail.NoteReplyImpl;
import kd.ebg.note.banks.abc.dc.service.note.detail.flow.NoteFlowImpl;
import kd.ebg.note.banks.abc.dc.utils.TypeConvertUtils;
import kd.ebg.note.banks.abc.dc.utils.TypeInfo;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.framework.utils.ParserUtils;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CQRM01";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return !"0".equals(noteDetailRequest.getBody().getIsNewECDS());
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "0";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        Element cme = JDomUtils.getChildElement((Element)root, (String)"Cme");
        String contLast = JDomUtils.getChildText((Element)cme, (String)"ContLast");
        return contLast;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element cmp;
        String contFlag;
        boolean flag = true;
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (!ResManager.loadKDString((String)"\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55\u3002", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo) && "0000".equals(rsp.getResponseCode()) && "1".equals(contFlag = JDomUtils.getChildText((Element)(cmp = JDomUtils.getChildElement((Element)root, (String)"Cmp")), (String)"ContFlag"))) {
            flag = false;
        }
        return flag;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subBizType = request.getHeader().getSubBizType();
        BankNoteDetailRequestBody body = request.getBody();
        BankAcnt acnt = request.getAcnt();
        String transType = body.getTranType();
        TypeInfo info = null;
        info = TypeConvertUtils.getReplayTypeInfo(transType);
        if (null == info) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u590d\u7c7b\u5b50\u4e1a\u52a1\u7c7b\u578b: %1$s\u7684\u4e1a\u52a1\u79cd\u7c7b\uff1a%2$s\u65e0\u6cd5\u8fdb\u884c\u5339\u914d\u3002\u4e0d\u652f\u6301\u6539\u4e1a\u52a1\u3002", (String)"NoteDetailImpl_11", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), subBizType, transType));
        }
        Element root = ABC_DC_Packer.createABCRoot4New("CQRM01");
        Element hermes = CommNotePacker.packNoteHeader(root, "0314");
        CommNotePacker.packCmpElement(root, acnt);
        JDomUtils.addChild((Element)hermes, (String)"BillTyp", (String)body.getDraftType());
        JDomUtils.addChild((Element)hermes, (String)"InNb", (String)body.getNoteNo());
        JDomUtils.addChild((Element)hermes, (String)"ResTyp", (String)info.getABCNoteType());
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        if ("0".equals(pageTag)) {
            JDomUtils.addChild((Element)cme, (String)"ContLast");
        } else {
            JDomUtils.addChild((Element)cme, (String)"ContLast", (String)pageTag);
        }
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        BankNoteDetailRequestBody body = request.getBody();
        List<Detail> detailList = new ArrayList<Detail>();
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (ResManager.loadKDString((String)"\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55\u3002", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo) || ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e", (String)"NoteDetailImpl_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo)) {
            return detailList;
        }
        if (!"0000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%s", (String)"NoteDetailImpl_12", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), RespInfo);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return detailList;
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        String[] splits = new String[]{};
        Element cmp = root.getChild("Cmp");
        if ("1".equals(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getDetailRspRecords(fileName, "");
        } else {
            String respPrvData = ParserUtils.checkUnNullableElement((Element)cmp, (String)"RespPrvData");
            splits = StringUtils.split((String)respPrvData, (String)"|");
        }
        int fieldNum = Integer.parseInt(fieldNumStr);
        String subBizType = request.getHeader().getSubBizType();
        detailList = this.parserReplyDetailInfos(splits, fieldNum, recordNum);
        return detailList;
    }

    /*
     * WARNING - void declaration
     */
    public EBBankDetailResponse doBizWithPage(BankNoteDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        List<Object> list = new ArrayList();
        ArrayList<Detail> detailList = new ArrayList<Detail>();
        BankNoteDetailRequestBody body = request.getBody();
        String transType = body.getTranType();
        try {
            String pageTag = this.getFirstPageTag();
            String responseStr = "";
            do {
                list = null;
                String requestStr = this.pack(request, pageTag);
                ConnectionFactory factory = this.getConnectionFactory();
                IConnection connection = this.getConnection(factory);
                this.openConnection(connection);
                try {
                    Throwable throwable = null;
                    try (OutputStream outputStream = this.getOutputStream(connection);){
                        this.send(outputStream, requestStr);
                        try (InputStream inputStream = this.getInputStream(connection);){
                            responseStr = this.recv(inputStream);
                            list = this.parse(request, responseStr);
                            pageTag = this.getNextPageTag(responseStr, pageTag);
                        }
                    }
                    catch (Throwable inputStream) {
                        Throwable throwable2 = inputStream;
                        throw inputStream;
                    }
                }
                catch (Exception e) {
                    void var13_22;
                    String string = ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"NoteDetailImpl_7", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
                    if (!StringUtils.isEmpty((String)e.getMessage())) {
                        String string2 = String.format(ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"NoteDetailImpl_8", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), e.getMessage());
                    }
                    throw EBExceiptionUtil.serviceException((String)var13_22, (Throwable)e);
                }
                for (Detail detail : list) {
                    NoteReplyNode node = this.convertDetail2Node(detail);
                    List<Detail> replyDetailInfos = new NoteReplyImpl().fitchNoteReplyDetails(request, "", acnt, node);
                    replyDetailInfos.get(0).setApplicationDate(detail.getApplicationDate());
                    if ("10".equals(request.getBody().getTranType()) || "20".equals(request.getBody().getTranType()) || "03".equals(request.getBody().getTranType())) {
                        if (null == replyDetailInfos || replyDetailInfos.size() <= 0) continue;
                        request.getBody().setNoteNo(replyDetailInfos.get(0).getNoteNo());
                        detailList.addAll(new NoteInfoImpl().fitchNoteDetails(request, acnt, replyDetailInfos.get(0)));
                        continue;
                    }
                    detailList.addAll(replyDetailInfos);
                }
            } while (!this.isLastPage(responseStr, pageTag));
            if ("10".equals(transType) || "20".equals(transType)) {
                this.logger.info("\u67e5\u8be2\u80cc\u9762\u4fe1\u606f\u5f00\u59cb");
                if (detailList != null) {
                    for (Detail info : detailList) {
                        try {
                            BankNoteDetailRequest rqst1 = new BankNoteDetailRequest();
                            BankHeader bankHeader = new BankHeader();
                            bankHeader.setSubBizType("flow");
                            rqst1.setHeader(bankHeader);
                            body.setNoteNo(info.getNoteNo());
                            rqst1.setBody(body);
                            List flows = new NoteFlowImpl().doBiz(rqst1).getDetails();
                            info.setNoteSidesInfo(((Detail)flows.get(0)).getNoteSidesInfo());
                        }
                        catch (Exception e) {
                            info.setIsNoteSidesError("Y");
                        }
                    }
                }
                this.logger.info("\u67e5\u8be2\u80cc\u9762\u4fe1\u606f\u7ed3\u675f");
            }
            return new EBBankDetailResponse(detailList);
        }
        catch (EBServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (String)"NoteDetailImpl_9", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private NoteReplyNode convertDetail2Node(Detail info) {
        NoteReplyNode node = new NoteReplyNode();
        node.setBankRefKey(info.getBankRefKey());
        node.setBillNo(info.getNoteNo());
        node.setBcTransCode("");
        node.setApplicantAccName(info.getApplicantAcName());
        node.setApplicantAccNo(info.getApplicantAcNo());
        node.setApplicantBankName(info.getApplicantBankName());
        node.setApplicantBankCnaps(info.getApplicantBankCnaps());
        return node;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        String subBizType = request.getHeader().getSubBizType();
        if ("hold".equals(subBizType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6301\u7968\u67e5\u8be2", (String)"NoteDetailImpl_10", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        return this.doBizWithPage(request);
    }

    private List<Detail> parserReplyDetailInfos(String[] splits, int fieldNum, int recordNum) {
        LinkedList<Detail> result = new LinkedList<Detail>();
        for (int i = 0; i < recordNum; ++i) {
            String noteNo = splits[fieldNum * i];
            String resNam = splits[fieldNum * i + 1];
            String BillAmt = splits[fieldNum * i + 2];
            String reDat = splits[fieldNum * i + 3];
            String reTim = splits[fieldNum * i + 4];
            String bppNam = splits[fieldNum * i + 5];
            String busCode = splits[fieldNum * i + 6];
            String transCode = splits[fieldNum * i + 7];
            Detail info = new Detail();
            info.setNoteNo(noteNo);
            if (!StringUtils.isEmpty((String)BillAmt)) {
                info.setAmount(BillAmt);
            }
            info.setBankRefKey(busCode);
            info.setExplain(resNam);
            info.setRemark(resNam);
            info.setApplicantAcName(bppNam);
            info.setApplicationDate(reDat.replaceAll("-", ""));
            result.add(info);
        }
        return result;
    }
}

