/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.codeless.detail.type;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.codeless.detail.CodelessBackInfo;
import kd.ebg.note.banks.ceb.dc.service.codeless.detail.CodelessInfoImpl;
import kd.ebg.note.business.noteDetail.atomic.codeless.CodeLessAbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class EndorseNoteDetailImpl
extends CodeLessAbstractNoteDetailImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e016036";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u80cc\u4e66\u5f85\u7b7e\u6536\u67e5\u8be2", (String)"EndorseNoteDetailImpl_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]);
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        int i = Integer.parseInt(pageTag);
        return (i += 20) + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Namespace ns = root.getNamespace();
        Element transContent = root.getChild("TransContent", ns);
        String sumnum = transContent.getChildTextTrim("SUMNUM", ns);
        int sum = Integer.parseInt(sumnum);
        int i = Integer.parseInt(pageTag);
        return i > sum;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public void configFactory(ConnectionFactory factory) {
        CEBHelper.configFactory(factory, this.getBizCode());
        super.configFactory(factory);
    }

    public String getDateStr() {
        return "yyyy-MM-dd";
    }

    public List<Detail> parserUtil(BankNoteDetailRequest request, String responStr) {
        Element root = JDomUtils.string2Root((String)responStr, (String)RequestContextUtils.getCharset());
        String ReturnCode = root.getChildTextTrim("ReturnCode");
        if (StringUtils.isNotEmpty((String)ReturnCode) && "role.user_has_not_enough_rights".equals(ReturnCode)) {
            String error = root.getChildTextTrim("error");
            throw EBExceiptionUtil.serviceException((String)error);
        }
        Namespace ns = root.getNamespace();
        Element transContent = root.getChild("TransContent", ns);
        String sumnum = transContent.getChildTextTrim("SUMNUM", ns);
        if ("0".equals(sumnum)) {
            ArrayList<Detail> result = new ArrayList<Detail>(0);
            return result;
        }
        List details = super.parserUtil(request, responStr);
        CodelessInfoImpl impl = new CodelessInfoImpl();
        BankNoteDetailRequest infoRequest = new BankNoteDetailRequest();
        infoRequest.setHeader(request.getHeader());
        for (Detail info : details) {
            info.setNoteStatus("CS03");
            info.setCirStatus("TF0302");
            BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
            infoRequest.setBody(body);
            body.setNoteNo(info.getNoteNo());
            body.setSubRange(info.getSubRange());
            EBBankDetailResponse response = impl.doBiz(infoRequest);
            List result = response.getDetails();
            Detail temp = (Detail)result.get(0);
            info.setDrawerAccNo(temp.getDrawerAccNo());
            info.setDrawerBankName(temp.getDrawerBankName());
            info.setDrawerCnapsCode(temp.getDrawerCnapsCode());
            info.setDrawerAccName(temp.getDrawerAccName());
            info.setPayeeCnapsCode(temp.getPayeeCnapsCode());
            info.setPayeeAccNo(temp.getPayeeAccNo());
            info.setPayeeAccName(temp.getPayeeAccName());
            info.setPayeeBankName(temp.getPayeeBankName());
        }
        return details;
    }

    public boolean isCodelessSide() {
        return true;
    }

    public String getStructIdSide() {
        return "b2e016081";
    }

    public List<Detail> getSideImpl(List<Detail> details) {
        BankNoteDetailRequest request = new BankNoteDetailRequest();
        CodelessBackInfo impl = new CodelessBackInfo();
        BankHeader header = new BankHeader();
        header.setAcnt(EBContext.getContext().getAcnt());
        header.setSubBizType("reply");
        request.setHeader(header);
        for (Detail detail : details) {
            try {
                BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
                body.setStartNo(detail.getStartNo());
                body.setEndNo(detail.getEndNo());
                body.setNoteNo(detail.getNoteNo());
                body.setDraftType(detail.getDraftType());
                request.setBody(body);
                EBBankDetailResponse response = impl.doBiz(request);
                List noteSidesInfo = ((Detail)response.getDetails().get(0)).getNoteSidesInfo();
                detail.setNoteSidesInfo(noteSidesInfo);
            }
            catch (Exception e) {
                detail.setIsNoteSidesError("Y");
            }
        }
        return details;
    }
}

