/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.codeless.receivable.endorse;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.codeless.receivable.QueryReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.atomic.codeless.CodeLessAbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CodelessEndorseImpl
extends CodeLessAbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceivableImpl.class;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "b2e016031";
    }

    public void configFactory(ConnectionFactory factory) {
        CEBHelper.configFactory(factory, this.getBizCode());
        super.configFactory(factory);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u80cc\u4e66\u7533\u8bf7", (String)"CodelessEndorseImpl_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]);
    }

    public String getDateStr() {
        return "yyyy-MM-dd";
    }

    public List<NoteReceivableInfo> parserUtil(BankNoteReceivableRequest request, String responStr) throws Exception {
        Namespace ns;
        List infos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responStr, (String)RequestContextUtils.getCharset());
        Element error = root.getChild("error", ns = root.getNamespace());
        if (error != null) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)"", (String)error.getTextTrim());
            return infos;
        }
        return super.parserUtil(request, responStr);
    }

    public String packerUtil(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        for (NoteReceivableInfo info : noteReceivableInfos) {
            info.setReserved1(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        }
        return super.packerUtil(request, pageTag);
    }
}

