/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.opa.service.note.util;

import com.icbc.api.response.MybankEnterpriseBillQbillinsResponseV1;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class ICBC_OPA_Parser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_OPA_Parser.class);

    public static void parseReceiveInfo(BankNoteReceivableRequest rqst, MybankEnterpriseBillQbillinsResponseV1 response) {
        List res = rqst.getNoteReceivableInfos();
        int i = 0;
        if (!response.isSuccess()) {
            EBGNoteReceivableUtils.setPaymentState((List)res, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u5f02\u5e38", (String)"ICBC_OPA_Parser_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else {
            List rds = response.getRd();
            for (MybankEnterpriseBillQbillinsResponseV1.MybankEnterpriseBillQbillinsResponseRdV1 rd : rds) {
                String code = rd.getInstrResult();
                ((NoteReceivableInfo)res.get(i)).setBillNo(rd.getPackNo());
                ((NoteReceivableInfo)res.get(i)).setStartNo(rd.getRangeBgn());
                ((NoteReceivableInfo)res.get(i)).setEndNo(rd.getRangeEnd());
                ((NoteReceivableInfo)res.get(i)).setSubRange(rd.getRangeBgn() + "," + rd.getRangeEnd());
                ((NoteReceivableInfo)res.get(i)).setAmount(ParserUtils.convertCentStr2Yuan((String)rd.getRangeAmt().toString()));
                String banmsg = rd.getBankRem();
                if ("17".equals(code) || "15".equals(code) || "18".equals(code) || "21".equals(code) || "26".equals(code)) {
                    EBGNoteReceivableUtils.setPaymentState((List)res, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"ICBC_OPA_Parser_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else if ("6".equals(code) || "5".equals(code) || "8".equals(code) || "12".equals(code) || "16".equals(code) || "19".equals(code) || "22".equals(code) || "27".equals(code)) {
                    EBGNoteReceivableUtils.setPaymentState((List)res, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ICBC_OPA_Parser_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else if ("0".equals(code) || "1".equals(code) || "2".equals(code) || "3".equals(code) || "7".equals(code) || "9".equals(code) || "10".equals(code) || "11".equals(code) || "14".equals(code) || "20".equals(code) || "24".equals(code) || "25".equals(code) || "23".equals(code)) {
                    EBGNoteReceivableUtils.setPaymentState((List)res, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ICBC_OPA_Parser_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else {
                    EBGNoteReceivableUtils.setPaymentState((List)res, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u672a\u77e5", (String)"ICBC_OPA_Parser_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                }
                if ("23".equals(code) || "17".equals(code) || "18".equals(code) || "19".equals(code) || "21".equals(code) || "22".equals(code) || "24".equals(code) || "26".equals(code) || "27".equals(code)) {
                    ((NoteReceivableInfo)res.get(i)).setIsRefuse("1");
                } else {
                    ((NoteReceivableInfo)res.get(i)).setIsRefuse("0");
                }
                ++i;
            }
        }
    }

    public static void parsePayableInfo(BankNotePayableRequest rqst, MybankEnterpriseBillQbillinsResponseV1 response) {
        List res = rqst.getNotePayableInfoList();
        int i = 0;
        if (!response.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u5f02\u5e38", (String)"ICBC_OPA_Parser_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else {
            List rds = response.getRd();
            for (MybankEnterpriseBillQbillinsResponseV1.MybankEnterpriseBillQbillinsResponseRdV1 rd : rds) {
                String code = rd.getInstrResult();
                ((NotePayableInfo)res.get(i)).setBillNo(rd.getPackNo());
                ((NotePayableInfo)res.get(i)).setStartNo(rd.getRangeBgn());
                ((NotePayableInfo)res.get(i)).setEndNo(rd.getRangeEnd());
                ((NotePayableInfo)res.get(i)).setAmount(ParserUtils.convertCentStr2Yuan((String)rd.getRangeAmt().toString()));
                String banmsg = rd.getBankRem();
                if ("17".equals(code) || "15".equals(code) || "18".equals(code) || "21".equals(code) || "26".equals(code)) {
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"ICBC_OPA_Parser_1", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else if ("6".equals(code) || "5".equals(code) || "8".equals(code) || "12".equals(code) || "16".equals(code) || "19".equals(code) || "27".equals(code)) {
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ICBC_OPA_Parser_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else if ("22".equals(code)) {
                    ((NotePayableInfo)res.get(i)).setIsRefuse("1");
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ICBC_OPA_Parser_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else if ("0".equals(code) || "1".equals(code) || "2".equals(code) || "3".equals(code) || "7".equals(code) || "9".equals(code) || "10".equals(code) || "11".equals(code) || "14".equals(code) || "20".equals(code) || "24".equals(code) || "25".equals(code) || "23".equals(code)) {
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ICBC_OPA_Parser_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else {
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u672a\u77e5", (String)"ICBC_OPA_Parser_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                }
                ++i;
            }
        }
    }

    public static void parsePayableInfoRegister(BankNotePayableRequest rqst, MybankEnterpriseBillQbillinsResponseV1 response) {
        List res = rqst.getNotePayableInfoList();
        int i = 0;
        if (!response.isSuccess()) {
            EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u5f02\u5e38", (String)"ICBC_OPA_Parser_0", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg());
        } else {
            List rds = response.getRd();
            for (MybankEnterpriseBillQbillinsResponseV1.MybankEnterpriseBillQbillinsResponseRdV1 rd : rds) {
                String code = rd.getInstrResult();
                ((NotePayableInfo)res.get(i)).setBillNo(rd.getPackNo());
                ((NotePayableInfo)res.get(i)).setStartNo(rd.getRangeBgn());
                ((NotePayableInfo)res.get(i)).setEndNo(rd.getRangeEnd());
                ((NotePayableInfo)res.get(i)).setAmount(ParserUtils.convertCentStr2Yuan((String)rd.getRangeAmt().toString()));
                String banmsg = rd.getBankRem();
                if ("6".equals(code) || "5".equals(code) || "8".equals(code) || "12".equals(code) || "16".equals(code) || "19".equals(code) || "27".equals(code)) {
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ICBC_OPA_Parser_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else if ("22".equals(code)) {
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ICBC_OPA_Parser_2", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else if ("0".equals(code) || "1".equals(code) || "2".equals(code) || "3".equals(code) || "7".equals(code) || "9".equals(code) || "14".equals(code)) {
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ICBC_OPA_Parser_3", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                } else {
                    EBGNotePayableUtils.setPaymentState((List)res, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u672a\u77e5", (String)"ICBC_OPA_Parser_4", (String)"ebg-note-banks-icbc-opa", (Object[])new Object[0]), (String)banmsg);
                }
                ++i;
            }
        }
    }
}

